/****************************************************************************** 
 *
 * File:        mpuconfig.c
 * Version:     $Id: mpuconfig.c,v 1.7 1995/07/28 01:33:53 burgaard Exp $
 *              $Version: 1.0$
 *
 * Purpose:     Configuration tool for the MPU-401 Device driver.
 *
 * Project:     Roland MPU-401 Device driver.
 * Authors:     Kim Burgaard, <burgaard@daimi.aau.dk>
 * Copyrights:  Copyright (c) 1994, 1995 Kim Burgaard.
 *
 *      This package is free software; you can redistribute it and/or modify it
 *      under the terms of the GNU General Public License as published by the
 *      Free Software Foundation; either version 2, or (at your option) any
 *      later version.
 *
 *      This package is distributed in the hope that it will be useful, but
 *      WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *      Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License along
 *      with this program; see the file COPYING. If not, write to the Free
 *      Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************************************/

/*** INCLUDES & DEFINES *******************************************************/

#include <errno.h>
#include <stdio.h>

#ifndef MPU_RC_FILE
#define MPU_RC_FILE "/var/lib/mpu401.conf"
#endif

/*** MAIN *********************************************************************/

unsigned int mpu_irq = 5;
unsigned int mpu_iop = 0x330;

char buf[8] = { 'M', 'P', 'U', '!', 0x00, 0x05, 0x03, 0x30 };
char ch;

FILE *CF = NULL;

int main(void)
{
  printf("MPU-401 Device driver configuration tool v1.0\n");
  printf("Copyright (c) 1994, 1995 Kim Burgaard.\n");
  printf("\n");
  
  if ( !(CF = fopen(MPU_RC_FILE, "rb") ) )
    printf("Creating new configuration file %s\n\n", MPU_RC_FILE);
  else
    {
      printf("Reading existing configuration file\n\n");
      if (fread(&buf[0], 1, 8, CF) == 8 && 
	  buf[0] == 'M' && buf[1] == 'P' && buf[2] == 'U' && buf[3] == '!')
	{
	  mpu_irq = (buf[4]<<8) | buf[5];
	  mpu_iop = (buf[6]<<8) | buf[7];
	  printf("old I/O Port: 0x%04x\n", mpu_iop);
	  printf("old IRQ:      0x%02x\n\n", mpu_irq);
	}
      else
	{
	  fprintf(stderr, "Error while reading old file.\n");
	};
    };

  fclose(CF);

  printf("Valid I/O Port adresses are even adresses in the range 0x200 to 0x0400\n");
  printf("Valid IRQ numbers are in the range 2 to 15\n");

  do
    {
      printf("Enter new I/O Port: ");
    }
  while ( scanf("%x", &mpu_iop) != 1 || mpu_iop % 2 || mpu_iop < 0x200 || mpu_iop > 0x400);
  
  do
    {
      printf("Enter new IRQ number: ");
    }
  while ( scanf("%d", &mpu_irq) != 1 || mpu_irq < 2 || mpu_irq > 0x10);

  if (mpu_irq == 2)
    {
      printf("\n   Remapping selected IRQ 2 to IRQ 9\n");
      mpu_irq = 9;
    };

  buf[4] = (char)(mpu_irq >> 8);
  buf[5] = (char)(mpu_irq & 0xff);

  buf[6] = (char)(mpu_iop >> 8);
  buf[7] = (char)(mpu_iop & 0xff);

  if ( !(CF = fopen(MPU_RC_FILE, "wb") ) )
    {
      fprintf(stderr, "\nCould not write to configuration file `%s\':", MPU_RC_FILE);
      perror("");
      return -3;
    };

  printf("\n");

  if ( !(fwrite(&buf[0], 1, 8, CF) == 8) ) perror("Error while writing new file");

  fclose(CF);

  return 0;
}

/*** END OF FILE **************************************************************/
