/*
 *  protos.c - Prototypes for all functions.
 *
 *  (C) 1994 Mikael Nordqvist (d91mn@efd.lth.se, mech@df.lth.se)
 */

/*
 *  Automagically generated Sat Oct 15 21:44:41 MET 1994.
 */

#ifndef _PROTOS_H
#define _PROTOS_H

#include <sys/types.h>
#include <linux/dirent.h>

/* User-defined types */

struct mod_message;
struct event;
struct sample_info;
struct mod_info;
struct voice;
struct effects;
struct options;
struct mod_file;

/* Function prototypes */

/* controller.c */
extern void main_loop(void);
extern void load_next_module(void);
extern char *basename(char *s);
extern void read_key(void);
extern void start_selecting(void);
extern void do_select_file(void);
extern void abort_selecting(void);
extern int should_autoselect_next(void);
extern void select_next_file(void);
extern void select_prev_file(void);
extern void read_sequencer(void);
extern void read_syncedmessage(void);
extern int pending_syncedmessage(void);
extern void handle_restart(int songpos);
extern void drain_pipes(char outgoing_too);
extern void set_voice_detail(int s);
extern void set_status(int s);
extern void send_to_player(struct mod_message *m);
extern void send_to_player_generic(void *m, int size);
extern void send_ack();
extern void wait_ack();

/* debug.c */
extern void debug(char *s, ...);
extern void error(char *s, ...);
extern void warning(char *s, ...);
extern void info(char *s, ...);

/* effects.c */
extern void check_tick0_efx(int v);
extern void check_efx(int v);
extern void check_remaining_efx(int v);
extern void set_speed(int s);
extern void set_tempo(int t);
extern void do_arpeggio(int v, int arg);
extern void do_volumeslide(int v, unsigned char arg);
extern void slide_volume(int v, int amount, char dir);
extern void do_set_portamento(int v, int amount, char dir);
extern void do_toneportamento(int v);
extern void do_vibrato(int v);
extern void do_tremolo(int v);
extern void set_pitch(int v);

/* file.c */
extern int choose_file(const struct dirent *de);
extern void init_dir(char *dirname);
extern void list_to_files(void);
extern char *get_filestring(int nr);
extern int name_to_filenr(char *name);
extern char *get_dirnamestring(int nr);
extern int is_dir(int nr);

/* help.c */
extern void print_helptext(char *av0);

/* init.c */
extern void init_sound(void);
extern void cleanup_sound(void) ;

/* load.c */
extern int load_module(void);
extern int is_modtype(char *type);
extern void guess_lha_filename(void);
extern void guess_zip_filename(void);
extern void guess_arj_filename(void);
extern void print_used_effects(void);
extern unsigned char period2note(unsigned int period);
extern void free_module(void);
extern void zero_resources(void);

/* load_mod.c */
extern int load_mod(int fd);
extern int get_voice_balance(int v);

/* load_mtm.c */
extern int load_mtm(int fd);

/* load_s3m.c */
extern int load_s3m(int fd);

/* load_ult.c */
extern int load_ult(int fd);

/* main.c */
extern int main(int argc, char *argv[]);
extern void my_removedir(char *name);
extern void write_pid(pid_t p);
extern void kill_mod(void);
extern void handler_quit(int sig);
extern void install_signalhandlers(void);

/* mklist.c */
extern void mklist(int argc, char *argv[]);

/* myseq.c */
extern void MY_SEQ_START_NOTE(int dev, int voice, int note, int vol);
extern void MY_SEQ_STOP_NOTE(int dev, int voice, int note, int vol);

/* options.c */
extern void init_options(int argc, char *argv[]);
extern void check_options(char no_files);
extern void parse_options(int index);
extern void cleanup_options(void);
extern int getarg(char **s, int *index);
extern void get_module(int nr);
extern char *get_modulename(int nr);
extern char *get_fullmodulename_ptr(int nr);
extern void init_playsequence(void);
extern int fileidx_to_seqidx(int nr);
extern int seqidx_to_fileidx(int nr);

/* play.c */
extern void play_tick(void);
extern void process_line(int continue_effects);
extern void total_reset(int spd, int tmpo, int pos);
extern void init_sequencer_voices(void);
extern void init_voices(void);
extern void set_modulepos(int pos);
extern int convert_volume(int v);
extern void do_set_finepitch(int v);

/* player.c */
extern void play_module(void);
extern void handle_IO(void);
extern void send_line(void);
extern void send_speed(void);

/* sample.c */
extern int read_and_upload_sample(int fd, int i);
extern void print_sample_info_header(void);
extern void print_sample_info(int i);

/* screen.c */
extern void init_screen(void);
extern void cleanup_screen(void);
extern void draw_screen();
extern void clear_screen(void);
extern void print_channelnumbers(int nr);
extern void print_selectingbar(void);
extern void print_songname(char *n);
extern void print_filename(int s);
extern void print_status(char *s);
extern void print_files(int n);
extern void print_samples(int n);
extern void print_minihelp(void);
extern void print_pos(int pos, int line);
extern void print_speed(int spd, int tempo);
extern void print_songinfo(int v, int samp, char *type, int sz, int songlen, int pat);
extern void print_time(int t);
extern void clear_all_info(void);
extern void print_line(int songpos, int line, int voice);
extern int print_event(char *buf, struct event *n);
extern void setup_color_mode(void);

/* tables.c */

/* util.c */
extern unsigned short SWAPSHORT(char *a);
extern unsigned long SWAPLONG(char *a);
extern void fix_string(char *s);
extern char *fill_string(char *s, int len);
extern void seqbuf_dump();
extern void change_mastervolume(int amount);
extern int get_track_idx(struct event *e);
extern int get_bytes(int fd, char *dest, int n);
extern void safe_read(int fd, struct mod_message *buf, int len);
extern void safe_write(int fd, struct mod_message *buf, int len);
extern int my_system(char *a);
extern char *escape_name(char *s, int a);

#endif /* _PROTOS_H */
