/*
 *  myseq.c - Wrappers for some sequencer-functions.
 *
 *  (C) 1994 Mikael Nordqvist (d91mn@efd.lth.se, mech@df.lth.se)
 */

#include <sys/soundcard.h>

#include "mod.h"

SEQ_DECLAREBUF();
extern int seqfd, gus_dev;
extern struct options opt;

void MY_SEQ_START_NOTE(int dev, int voice, int note, int vol)
{
    SEQ_START_NOTE(dev, voice, note, (opt.active_voices&(1<<voice) ? vol : 0));
}

void MY_SEQ_STOP_NOTE(int dev, int voice, int note, int vol)
{
    SEQ_STOP_NOTE(dev, voice, note, (opt.active_voices&(1<<voice) ? vol : 0));
}
