/*
 *  help.c - Help and usage texts.
 *
 *  (C) 1994 Mikael Nordqvist (d91mn@efd.lth.se, mech@df.lth.se)
 */

#include <stdio.h>

#define USAGE_TEXT "\
mod version 0.6 Copyright (C) Mikael Nordqvist, 1994.\n\n\
Usage: %s [global options] file [options] file [options] ...\n"

#define HELP_TEXT USAGE_TEXT "\
\n\
Options always global:\n\
\n\
  -a        Enable auto-next             -l <arg>  Number of scroll-lines\n\
  -A        Disable auto-next            -n        Disable scrolling\n\
  -b        Break loops                  -q        Quiet mode\n\
  -B        Allow loops                  -Q        Totally quiet mode\n\
  -C        Cyclic play of modules       -r        Play modules randomly\n\
  -D        Set directory                -v        Verbose mode\n\
  -h        Help                         -z        Put mod in background\n\
  -k        Kill mod in background\n\
\n\
Module-specific options:\n\
\n\
  -c <arg>  Click removal                -P        PAL-amiga samplepitch\n\
  -f <arg>  Module format                -s <arg>  Set speed\n\
  -L        Loop module                  -t <arg>  Set tempo\n\
  -m <arg>  Maximum moduletime           -T        Tolerant mode\n\
  -M        Mono output                  -x <arg>  Detail of voice-information\n\
  -N        NTSC-amiga samplepitch       -0        Ignore speedchanges to 0\n\
  -o        Octaves 1-3                  -5        PAL-amiga (50 Hz) tempo\n\
  -O        Octaves 0-7                  -6        NTSC-amiga (60 Hz) tempo\n\
  -p <arg>  Start-position\n\
"

static char helptext[]=HELP_TEXT;

void print_helptext(char *av0)
{
    printf(helptext, av0);
}
