#include	<libmidi.h>
#include	<libmirage.h>

char	*Mir_cdn[]	= {	/* Mirage configuration dump names */
	"           Dummy byte (zero)",
	"[21] 0-99  Master Tune",
	"[22] 0-34  Pitch Bend Range",
	"[23] 0-63  Velocity Sens.",
	"[24] 0-126 U/L Balance(*2)",
	"[25] 0-1   Program Link Switch",
	"[73] 20-99 Sample Time Adjust",
	"[74] 0-198 Input Filter Freq(*2)",
	"[75] 0-1   Mic/Line Switch",
	"[76] 0-126 Sampling Threshold(*2)",
	"[77] 0-1   Multisample Switch",
	"[81] 0-1   MIDI Omni Mode",
	"[82] 0-15  MIDI Channel",
	"[83] 0-1   MIDI Thru Mode",
	"[84] 0-1   MIDI Mod Enable",
	"[85] 0-255 Source Start MSB",
	"[86] 0-255 Source Start LSB",
	"[87] 0-255 Source End MSB",
	"[88] 0-255 Source End LSB",
	"[89] 0-255 Destination MSB",
	"[90] 0-255 Destination LSB",
	"[94] 0-1   Destination Bank",
	"[95] 0-255 Scale Start Factor",
	"[96] 0-255 Scale End Factor",
	"[91] 0-1   External Comp.",
	"[92] 0-1   Baud Rate",
	"[93] 0-25  Cart. Filter Freq.",
	"[97] 0-255 Software Version",
	"     0-255 Spare",
};

char	*Mir_wcbn[]	= {	/* Mirage wavesample control block names */
	"           Sample Start Ptr lo",
	"           Sample Start Ptr hi",
	"           Sample End Ptr lo",
	"           Sample End Ptr hi",
	"           Loop Start Ptr lo",
	"           Loop Start Ptr hi",
	"           Loop End Ptr lo",
	"           Loop End Ptr hi",
	"[65] 0-1   Loop Switch",
	"[67] 0-7   Coarse Tune",
	"[68] 0-255 Fine Tune",
	"[69] 0-63  Relative Amplitude",
	"[70] 0-198 Relative Filter Freq.",
	"[71] 0-198 Maximum Filter Freq.",
	"[72] 0-60  Top Key",
	"[60] 0-FE  Wavesample Start",
	"[61] 1-FF  Wavesample End",
	"[62] 0-FE  Loop Start",
	"[63] 1-FF  Loop End",
	"[64] 0-FF  Loop End Fine",
	"     0-1   Free Run Flag",
	"     0     Spare",
	"     0     Spare",
	"     0     Spare",
};

char	*Mir_ppbn[]	= {	/* Mirage program parameter block names */
	"[28] 0-1   Mono Mode Switch",
	"[31] 0-99  LFO Frequency",
	"[32] 0-99  LFO Depth",
	"[33] 0-99  Osc. Detune",
	"[34] 0-252 Osc. Mix",
	"[35] 0-124 Mix Vel. Sens.",
	"[36] 0-198 Filter Cutoff Freq.",
	"[37] 0-160 Resonance",
	"[38] 0-4   Filter Kbd Tracking",
	"     0     Spare",
	"[27] 0-7   Initial Wavesample",
	"[28] 0-1   Mix Mode Switch",
	"[40] 0-31  A Filter Envelope",
	"[41] 0-31  P Filter Envelope",
	"[42] 0-31  D Filter Envelope",
	"[43] 0-31  S Filter Envelope",
	"[44] 0-31  R Filter Envelope",
	"[45] 0-124 Av Filter Envelope",
	"[46] 0-124 Pv Filter Envelope",
	"[47] 0-124 Dk Filter Envelope",
	"[48] 0-124 Sv Filter Envelope",
	"[49] 0-124 Rv Filter Envelope",
	"[50] 0-31  A Amplitude Envelope",
	"[51] 0-31  P Amplitude Envelope",
	"[52] 0-31  D Amplitude Envelope",
	"[53] 0-31  S Amplitude Envelope",
	"[54] 0-31  R Amplitude Envelope",
	"[55] 0-124 Av Amplitude Envelope",
	"[56] 0-124 Pv Amplitude Envelope",
	"[57] 0-124 Dk Amplitude Envelope",
	"[58] 0-124 Sv Amplitude Envelope",
	"[59] 0-124 Rv Amplitude Envelope",
	"     0     Spare",
	"     0     Spare",
	"     0     Spare",
	"     0     Spare",
};

char	*Mir_but[]	= {	/* Mirage button names */
	"0/PROG",	"1",		"2",		"3",
	"4",		"5",		"6",		"7",
	"8",		"9",		"ENTER/START",	"CANCEL/STOP",
	"PARAM",	"VALUE",	"ON/UP",	"OFF/DOWN",
	"LOAD UPPER",	"LOAD LOWER",	"SAMPLE UPPER",	"SAMPLE LOWER",
	"REC SEQ",	"PLAY SEQ",	"LOAD SEQ",	"SAVE SEQ",
};

struct	mirpstr	Masos_par[]	= {	/* parameters for MASOS */
/*00*/	{ "TOGGLE UPPER/LOWER", "", MP_ACT, },
/*01*/	{ "SELECT PROGRAM 1", "", MP_ACT, },
/*02*/	{ "SELECT PROGRAM 2", "", MP_ACT, },
/*03*/	{ "SELECT PROGRAM 3", "", MP_ACT, },
/*04*/	{ "SELECT PROGRAM 4", "", MP_ACT, },
/*05*/	{ 0, },
/*06*/	{ 0, },
/*07*/	{ 0, },
/*08*/	{ 0, },
/*09*/	{ 0, },
/*10*/	{ "?", "?", 0, },
/*11*/	{ "SAVE LOWER KBD SOUND", "", MP_ACT, },
/*12*/	{ "SAVE UPPER KBD SOUND", "", MP_ACT, },
/*13*/	{ "SAVE BOTH KBD SOUNDS", "", MP_ACT, },
/*14*/	{ "SAVE CONFIG. PARAMS", "", MP_ACT, },
/*15*/	{ "COPY PROGRAM TO LOWER", "", MP_ACT, },
/*16*/	{ "COPY PROGRAM TO UPPER", "", MP_ACT, },
/*17*/	{ "COPY WAVESAMPLE TO LOWER N", "", MP_ACT, },
/*18*/	{ "COPY WAVESAMPLE TO UPPER N", "", MP_ACT, },
/*19*/	{ "ROTATE WAVESAMPLE LEFT BY N", "", MP_ACT, },
/*20*/	{ "ROTATE WAVESAMPLE RIGHT BY N", "", MP_ACT, },
/*21*/	{ "MASTER TUNE", "1/20 semitone", MP_PROG, MP_DEC, 0, 1, 0, 99, },
/*22*/	{ "PITCH BEND RANGE", "semitone", MP_PROG, MP_DEC, 0, 1, 0, 12, },
/*23*/	{ "KBD VELOCITY SENS", "", MP_PROG, MP_DEC, 0, 1, 0, 63, },
/*24*/	{ "KBD BALANCE", "", MP_PROG, MP_DEC, 0, 2, 0, 63, },
/*25*/	{ "UPPER/LOWER PROG LINK", "", MP_PROG, MP_BOOL, 0, 1, 0, 1, },
/*26*/	{ "WAVESAMPLE SELECT", "", MP_WSEL, MP_DEC, 1, 1, 1, 8, },
/*27*/	{ "INITIAL WAVESAMPLE", "", MP_PROG, MP_DEC, 1, 1, 1, 8, },
/*28*/	{ "MIX MODE", "", MP_PROG, MP_BOOL, 0, 1, 0, 1, },
/*29*/	{ "MONOPHONIC MODE", "", MP_PROG, MP_BOOL, 0, 1, 0, 1, },
/*30*/	{ 0, },
/*31*/	{ "LFO SPEED", "", MP_PROG, MP_DEC, 0, 1, 0, 99, },
/*32*/	{ "LFO DEPTH", "", MP_PROG, MP_DEC, 0, 1, 0, 99, },
/*33*/	{ "D.O. DETUNE", "Hertz", MP_PROG, MP_DEC, 0, 1, 0, 99, },
/*34*/	{ "D.O. BALANCE", "", MP_PROG, MP_DEC, 0, 4, 0, 63, },
/*35*/	{ "D.O. BALANCE VS", "", MP_PROG, MP_DEC, 0, 4, 0, 31, },
/*36*/	{ "FILTER Fc", "", MP_PROG, MP_DEC, 0, 2, 0, 99, },
/*37*/	{ "FILTER Q", "", MP_PROG, MP_DEC, 0, 4, 0, 40, },
/*38*/	{ "FILTER TRACKING", "", MP_PROG, MP_DEC, 0, 1, 0, 4, },
/*39*/	{ 0, },
/*40*/	{ "FILTER ATTACK", "~secs", MP_PROG, MP_DEC, 0, 1, 0, 31, },
/*41*/	{ "FILTER PEAK", "", MP_PROG, MP_DEC, 0, 1, 0, 31, },
/*42*/	{ "FILTER DECAY", "~secs", MP_PROG, MP_DEC, 0, 1, 0, 31, },
/*43*/	{ "FILTER SUSTAIN", "", MP_PROG, MP_DEC, 0, 1, 0, 31, },
/*44*/	{ "FILTER RELEASE", "~secs", MP_PROG, MP_DEC, 0, 1, 0, 31, },
/*45*/	{ "FILTER ATTACK VS", "", MP_PROG, MP_DEC, 0, 4, 0, 31, },
/*46*/	{ "FILTER PEAK VS", "", MP_PROG, MP_DEC, 0, 4, 0, 31, },
/*47*/	{ "FILTER DECAY - KBD SCALED", "", MP_PROG, MP_DEC, 0, 4, 0, 31, },
/*48*/	{ "FILTER SUSTAIN VS", "", MP_PROG, MP_DEC, 0, 4, 0, 31, },
/*49*/	{ "FILTER RELEASE VS", "", MP_PROG, MP_DEC, 0, 4, 0, 31, },
/*50*/	{ "ATTACK RATE", "~secs", MP_PROG, MP_DEC, 0, 1, 0, 31, },
/*51*/	{ "PEAK LEVEL", "", MP_PROG, MP_DEC, 0, 1, 0, 31, },
/*52*/	{ "DECAY RATE", "~secs", MP_PROG, MP_DEC, 0, 1, 0, 31, },
/*53*/	{ "SUSTAIN LEVEL", "", MP_PROG, MP_DEC, 0, 1, 0, 31, },
/*54*/	{ "RELEASE RATE", "~secs", MP_PROG, MP_DEC, 0, 1, 0, 31, },
/*55*/	{ "ATTACK VS", "", MP_PROG, MP_DEC, 0, 4, 0, 31, },
/*56*/	{ "PEAK LEVEL VS", "", MP_PROG, MP_DEC, 0, 4, 0, 31, },
/*57*/	{ "DECAY - KBD SCALED", "", MP_PROG, MP_DEC, 0, 4, 0, 31, },
/*58*/	{ "SUSTAIN LEVEL VS", "", MP_PROG, MP_DEC, 0, 4, 0, 31, },
/*59*/	{ "RELEASE RATE VS", "", MP_PROG, MP_DEC, 0, 4, 0, 31, },
/*60*/	{ "WAVESAMPLE START", "pages", MP_WAVE, MP_HEX, 0, 1, 0, 255, },
/*61*/	{ "WAVESAMPLE END", "pages", MP_WAVE, MP_HEX, 0, 1, 0, 255, },
/*62*/	{ "LOOP START", "pages", MP_WAVE, MP_HEX, 0, 1, 0, 255, },
/*63*/	{ "LOOP END", "pages", MP_WAVE, MP_HEX, 0, 1, 0, 255, },
/*64*/	{ "LOOP END FINE ADJUST", "bytes", MP_WAVE, MP_HEX, 0, 1, 0, 255, },
/*65*/	{ "LOOP SWITCH", "", MP_WAVE, MP_BOOL, 0, 1, 0, 1, },
/*66*/	{ "WAVESAMPLE ROTATE", "", MP_ACT, },
/*67*/	{ "REL. TUNING - COARSE", "octaves", MP_WAVE, MP_HEX, 0, 1, 0, 7, },
/*68*/	{ "REL. TUNING - FINE", "semitone/20", MP_WAVE, MP_HEX, 0, 1, 0, 255, },
/*69*/	{ "REL. AMPLITUDE", "", MP_WAVE, MP_DEC, 0, 1, 0, 63, },
/*70*/	{ "REL. FILTER FREQ.", "", MP_WAVE, MP_DEC, 0, 2, 0, 99, },
/*71*/	{ "MAX. FILTER FREQ.", "", MP_WAVE, MP_DEC, 0, 2, 0, 99, },
/*72*/	{ "TOP KEY", "", MP_WAVE, MP_DEC, 1, 1, 1, 61, },
/*73*/	{ "SAMPLE TIME ADJUST", "usecs", MP_PROG, MP_DEC, 0, 1, 30, 99, },
/*74*/	{ "INPUT FILTER FREQ.", "", MP_PROG, MP_DEC, 0, 2, 0, 99, },
/*75*/	{ "LINE LEVEL INPUT", "", MP_PROG, MP_BOOL, 0, 1, 0, 1, },
/*76*/	{ "SAMPLING THRESHOLD", "", MP_PROG, MP_DEC, 0, 2, 0, 63, },
/*77*/	{ "USER MULTISAMPLING", "", MP_PROG, MP_BOOL, 0, 1, 0, 1, },
/*78*/	{ 0, },
/*79*/	{ 0, },
/*80*/	{ 0, },
/*81*/	{ "MIDI OMNI MODE", "", MP_PROG, MP_BOOL, 0, 1, 0, 1, },
/*82*/	{ "MIDI CHANNEL SELECT", "", MP_PROG, MP_DEC, 1, 1, 1, 16, },
/*83*/	{ "MIDI THRU MODE", "", MP_PROG, MP_BOOL, 0, 1, 0, 1, },
/*84*/	{ "MIDI CONTROLLER ENABLE", "", MP_PROG, MP_BOOL, 0, 1, 0, 1, },
/*85*/	{ "FCN SOURCE START", "pages", MP_PROG, MP_HEX, 0, 1, 0, 255, },
/*86*/	{ "FCN SOURCE START FINE", "bytes", MP_PROG, MP_HEX, 0, 1, 0, 255, },
/*87*/	{ "FCN SOURCE END", "pages", MP_PROG, MP_HEX, 0, 1, 0, 255, },
/*88*/	{ "FCN SOURCE END FINE", "bytes", MP_PROG, MP_HEX, 0, 1, 0, 255, },
/*89*/	{ "FCN DEST START", "pages", MP_PROG, MP_HEX, 0, 1, 0, 255, },
/*90*/	{ "FCN DEST START FINE", "bytes", MP_PROG, MP_HEX, 0, 1, 0, 255, },
/*91*/	{ "EXT COMPUTER PORT ENABLE", "", MP_PROG, MP_BOOL, 0, 1, 0, 1, },
/*92*/	{ "SERIAL PORT BAUD RATE", "", MP_PROG, MP_BOOL, 0, 1, 0, 1, },
/*93*/	{ "EXT INPUT FILTER FREQ", "", MP_PROG, MP_DEC, 0, 1, 0, 25, },
/*94*/	{ "FCN DEST BANK SELECT", "", MP_PROG, MP_DEC, 0, 1, 0, 1, },
/*95*/	{ "FCN SCALE START FACTOR", "", MP_PROG, MP_HEX, 0, 1, 0, 255, },
/*96*/	{ "FCN SCALE END FACTOR", "", MP_PROG, MP_HEX, 0, 1, 0, 255, },
/*97*/	{ "SOFTWARE VERSION NUMBER", "", MP_PROG, MP_HEX, 0, 1, 0, 255, },
/*98*/	{ "DISK ERROR CODE", "", MP_PROG, MP_DEC, 0, 1, 0, 8, },
/*99*/	{ "DISK CONTROLLER STATUS CODE", "", MP_PROG, MP_DEC, 0, 1, 0, 99, },
};
