/************************************************************************/
/*  pva.c	    (after pvanal.c)					*/
/*  Frequency Domain Analysis						*/
/*  Takes a time domain soundfile and converts it into a file of	*/
/*  This version just calculates pure FFT rather than PVOC's phi-dot	*/
/*  More importantly, it reads from disk rather than using so much core */
/*  dpwe  14feb91							*/
/************************************************************************/

#include "cs.h"
#include "soundio.h"
#include "fft.h"
#include "dsputil.h"
#include "pvoc.h"

#ifdef __STDC__			/* prototype arguments */
static long takeFFTs(SOUNDIN *inputSound, PVSTRUCT *outputPVH,
		     int sndfd, int fftd, long oframeEst);
static void quit(char *msg);
static void PrintBuf(float *buf, long size, char *msg);
#else				/* no argument prototypes */
static long takeFFTs();
static void quit();
static void PrintBuf();
#endif

#define MINFRMMS	20	/* frame defaults to at least this many ms */
#define MAXFRMPTS	65536
#define MINFRMPTS	16	/* limits on fft size */
#define OVLP_DEF	4	/* default frame overlap factor */
#define SF_UNK_LEN      -1      /* code for sndfile len unkown  */

int	    debug = 0;		/* tweaked inside ! */
char        *programName = "PVANAL";  /* TEMP FOR pvoc.c ******/

static	long frameSize	= 0;	    /* size of FFT frames */
static	long frameIncr	= 0;	    /* step between successive frames */
static	long fftfrmBsiz	= 0;	    /* bytes of fft output frame      */
static  complex *basis;             /* LUTable for FFT */

extern	int      SAsndgetset();
extern	long     getsndin();

#define FIND(MSG)   if (*s == '\0')  \
		        if (!(--argc) || (s = *++argv) && *s == '-')  \
			    quit(MSG);

pvanal(argc,argv)
     int argc;
     char **argv;
{
        PVSTRUCT *pvh;
        char	*infilnam, *outfilnam;
        int 	infd, ofd, err, channel = 1;
        int     i, ovlp = 0;		/* number of overlapping windows to have */
	SOUNDIN  *p;  /* space allocated by SAsndgetset() */
extern  char     *retfilnam;

	float    fzero = 0., beg_time = 0., input_dur = 0., sr = 0.;
	long     oframeEst = 0, oframeAct;  /* output frms estimated, & actual */
	long     Estdatasiz;
	long     nsamps, nb, n;

        if (!(--argc))	    quit("insufficient arguments");
	do {
	    register char *s = *++argv;
	    if (*s++ == '-')
	        switch (*s++) {
		case 's':  FIND("no sampling rate")
			   sscanf(s,"%f",&sr);
		           break;
		case 'c':  FIND("no channel")
			   sscanf(s,"%d",&channel);
			   break;
		case 'b':  FIND("no begin time")
			   sscanf(s,"%f",&beg_time);
			   break;
		case 'd':  FIND("no duration time")
			   sscanf(s,"%f",&input_dur);
			   break;
		case 'n':  FIND("no framesize")
		           sscanf(s,"%ld",&frameSize);
		           if (frameSize < MINFRMPTS || frameSize > MAXFRMPTS) {
			       sprintf(errmsg,"frameSize must be between %d &%d\n",
				       MINFRMPTS, MAXFRMPTS);
			       quit(errmsg);
			   }
			   if (!(IsPowerOfTwo(frameSize)))  {
			       sprintf(errmsg,"pvanal: frameSize must be 2^r");
			       quit(errmsg);
			   }
		           break;
		case 'w':  FIND("no windfact")
		           sscanf(s,"%d",&ovlp);
		           break;
		case 'h':  FIND("no hopsize")
		           sscanf(s,"%d",&frameIncr);
		           break;
		default:   quit("unrecognized switch option");
	        }
	    else break;
	} while (--argc);

	if (argc !=  2) quit("illegal number of filenames");
	infilnam = *argv++;
	outfilnam = *argv;

	if (ovlp && frameIncr) quit("pvanal cannot have both -w and -h");
						   /* open sndfil, do skiptime */
	if (!(infd = SAsndgetset(infilnam,&p,&beg_time,&input_dur,&sr,channel))) {
	    sprintf(errmsg,"error while opening %s", retfilnam);
	    quit(errmsg);
	}
	sr = p->sr;
	/* setup frame size etc according to sampling rate */
	if (frameSize == 0) {		/* not specified on command line */
	    int	target;
	    target = sr * (float)MINFRMMS / (float)1000;
	    frameSize = MAXFRMPTS;	/* default frame size is > MINFRMMS msecs */
	    while ((frameSize>>1) >= target && frameSize > MINFRMPTS)
	        frameSize >>= 1;	/* divide down until just larger */
	}
	if (ovlp == 0 && frameIncr == 0) {
	    ovlp = OVLP_DEF;    	/* default overlap */
	    frameIncr = frameSize / ovlp;
	}
	else if (ovlp == 0)
	    ovlp = frameSize/frameIncr;
	else frameIncr = frameSize/ovlp;

	if (ovlp < 2 || ovlp > 16) {
	    fprintf(stderr, "pvanal: %d is a bad window overlap index\n", ovlp);
	    exit(1);
	}
	oframeEst = (p->getframes - frameSize/2) / frameIncr;
	printf("%ld infrsize, %ld infrInc\n", frameSize, frameIncr);
	printf("%ld output frames estimated\n", oframeEst);

	fftfrmBsiz = sizeof(float) * 2 * (frameSize/2 + 1);
	Estdatasiz = oframeEst * fftfrmBsiz;
	                                           /* alloc & fill PV hdrblk */
	if ((err = PVAlloc(&pvh, Estdatasiz, PVFLOAT, sr, p->nchnls, frameSize,
			frameIncr, fftfrmBsiz, PVPVOC, 0.0, sr/2.0, PVLIN, 4))) {
	    fprintf(stderr, "pvanal: %s\n", PVErrMsg(err));
	    exit(1);
	  }
	if ((ofd = openout(outfilnam, 1)) < 0)     /* open the output PV file */
	    quit("cannot create output file");
	                                           /* & wrt hdr into the file */
	if ((nb = write(ofd,(char *)pvh,(int)pvh->headBsize)) < pvh->headBsize)
	    quit("can't write header");

	basis = AssignBasis(NULL,frameSize);      /* set up FFT tables */
	oframeAct = takeFFTs(p, pvh, infd, ofd, oframeEst);
	printf("%ld output frames written\n", oframeAct);

/*	outputPVH->dataBsize = oframeAct * fftfrmBsiz;
/*	PVCloseWrHdr(ftFile, outputPVH);    /* Rewrite dataBsize, Close files */

	close(infd);
	close(ofd);
	exit(0);
}

static void quit(msg)
     char *msg;
{
	fprintf(stderr,"pvanal error: %s\n", msg);
	fprintf(stderr,
	"Usage: pvanal [-n<frmsiz>] [-w<windfact> | -h<hopsize>] inputSoundfile outputFFTfile\n");
	exit(0);
}

/*    if(debug)
/*	printf("Framesiz %ld, framInc %ld\n",frameSize, frameIncr);
/*    /* If we dealt with frames that hit the ends properly, we'd have */
/*    /*	 (size/sizeof(short))/frameIncr frames (>= 1/2 inside file) */
/*    frameWords = frameSize + 2L; /* each frame has Mag & phase for n/2 +1 */
/*    if(inputSound->dataBsize != SF_UNK_LEN)
/*	printf("Est. frames %ld\n", 
/*       inputSound->dataBsize/(dsize*frameIncr));

/*	chans = 1;	/* will write # chans into PV header tho' only mono */
/*
 * takeFFTs
 *  Go through the (mono) input sound frame by frame and find the
 *  magnitude and phase change for a string of FFT bins
 */

static long takeFFTs(p, outputPVH, infd, ofd, oframeEst)
    SOUNDIN	    *p;
    PVSTRUCT	    *outputPVH;
    int 	    infd, ofd;
    long            oframeEst;
{
        long    i = -1, nn, read_in;
	float   *inBuf, *tmpBuf, *oldInPh, *winBuf;
	float   sampRate = p->sr;  /* not really */
	long    fsIndepVals = (frameSize/2L)+1L;
register float  *fp1, *fp2;
	float   dv32768 = 1. / 32768.;

	inBuf   = (float *)MakeBuf(frameSize * 2L);
	tmpBuf  = MakeBuf(frameSize * 2L);
	oldInPh = MakeBuf(frameSize);
	winBuf  = MakeHalfWin(frameSize,(float)1.0,1);

	                     /* initially, clear first half of buffer .. */
	for (fp1=inBuf, nn=frameSize/2; nn--; )
	    *fp1++ = 0.;
	                     /* .. and read in second half from file */
	if ((read_in = getsndin(infd, fp1, (long)(frameSize/2),p)) < frameSize/2)
	    die("insufficient sound for analysis");
	for (nn = read_in; nn--; )
	    *fp1++ *= dv32768;      /* normalize the samples read in */
	oframeEst -= 1;
	printf("frame: ");
	do {
	    if (((++i)%20)==0)   printf("%ld ", i); fflush(stdout);
	                      /*	copy the current frame */
	    for (fp1=inBuf, fp2=tmpBuf, nn=frameSize; nn--; )
	        *fp2++ = *fp1++;
	/*    PrintBuf(tmpBuf, frameSize, "floated"); /* */
	    ApplyHalfWin(tmpBuf,winBuf,frameSize);
	/*    PrintBuf(tmpBuf, frameSize, "windo'd"); /* */
	    UnpackReals(tmpBuf, frameSize);
	/*    PrintBuf(tmpBuf, frameSize, "unpacked"); /* */
	    FFT2real((complex *)tmpBuf, frameSize, 1, basis);
	/*    PrintBuf(tmpBuf, frameSize, "fft'd"); /* */
	    Rect2Polar(tmpBuf, fsIndepVals);
	/*    PrintBuf(tmpBuf, frameSize, "toPolar"); /* */
	    UnwrapPhase(tmpBuf, fsIndepVals, oldInPh);
	/*    PrintBuf(tmpBuf, frameSize, "unWrapped"); /* */
	    PhaseToFrq(tmpBuf, fsIndepVals, (float)frameIncr, (float)sampRate);
	/*    PrintBuf(tmpBuf, frameSize, "toFrq"); /* */
	     /* write straight out, just the indep vals */
	    write(ofd, (char *)tmpBuf, fftfrmBsiz);
	    if (!read_in)            /* if previous read had hit EOF, we're done */
	        break;               /* mv conts fwrd by frameIncr, rd more pnts */
	    for (fp1=inBuf+frameIncr, fp2=inBuf, nn=frameSize-frameIncr; nn--; )
	        *fp2++ = *fp1++;     /* getsndin pads with zeros if not complete */
	    read_in = getsndin(infd, inBuf+frameSize-frameIncr, frameIncr, p);
	    for (fp1 = inBuf+frameSize-frameIncr, nn = read_in; nn--; )
	        *fp1++ *= dv32768;            /* normalize samples just read in */
	     /* debug = 0;	/* */
	} while (i < oframeEst);
	printf("%ld\n",i);
	if (i < oframeEst)
	  printf("\tearly end of file\n");
	return((long)i + 1);
}

#define DBGPTS 8
static void PrintBuf(buf,size,msg)
    float *buf;
    long   size;
    char  *msg;
{
        int   i;
/*      if (!debug) return;   */
/*	size = DBGPTS;      */
	printf("%s:",msg);
	for (i=0; i<DBGPTS; ++i)
	    printf("%7.2f ",buf[i]);
	printf("\n");
}


