/******************************************************************************
 *
 * File:        mpuioctl.h
 * Version:     $Id: mpuioctl.h,v 1.9 1995/07/21 11:08:29 burgaard Exp $
 *
 * Project:     Roland MPU-401 Device driver.
 * Authors:     Kim Burgaard, <burgaard@daimi.aau.dk>
 * Copyrights:  Copyright (c) 1994, 1995 Kim Burgaard.
 *
 *      This package is free software; you can redistribute it and/or modify it
 *      under the terms of the GNU General Public License as published by the
 *      Free Software Foundation; either version 2, or (at your option) any
 *      later version.
 *
 *      This package is distributed in the hope that it will be useful, but
 *      WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *      Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License along
 *      with this program; see the file COPYING. If not, write to the Free
 *      Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************************************
 *
 *  !!! IMPORTANT !!! Do not fill more than 50-200 events onto the driver
 *  queues at a time. It cant possibly be played at once and then we would just
 *  waste precious kernel memory for nothing!
 *
 ******************************************************************************/

/*** INCLUDES & DEFINES *******************************************************/

#ifndef __MPU_IOCTL_H
#define __MPU_IOCTL_H

#include <linux/ioctl.h>
#include <linux/major.h>

#include "miditypes.h"
#include "midiqueue.h"
#include "mpu401.h"

/*** /dev DEFINES ***********************************************************/

#define MPU_DEV_MAJOR 31 /* officially allocated device number */

/* These are the MINOR numbers */

#define MPU_DEV_RW 0
#define MPU_DEV_STATUS 1

/*** I/O CONTROL ************************************************************/

#define MPUIOC_RESET           _IO  ('M', 0x00)

/*** sequence commands ******************************************************/

/* the long type argument is *NOT* a pointer! It is the initial time tick count
 * NOTE: the initial time tick count must be beat aligned, that is:
 * (initime % timebase) == 0. If not, then the closest lower value will be chosen! */
#define MPUIOC_START_PLAY       _IOW ('M', 0x10, long)
#define MPUIOC_STOP_PLAY        _IO  ('M', 0x11)
#define MPUIOC_START_OVERDUB    _IOW ('M', 0x12, long)
#define MPUIOC_STOP_OVERDUB     _IO  ('M', 0x13)
#define MPUIOC_START_RECORD     _IOW ('M', 0x14, long)
#define MPUIOC_STOP_RECORD      _IO  ('M', 0x15)
#define MPUIOC_START_STEPREC    _IO  ('M', 0x16)
#define MPUIOC_STOP_STEPREC     _IO  ('M', 0x17)
#define MPUIOC_STOP_ALL         _IO  ('M', 0x18)

/* blocking system */
#define MPUIOC_BLOCK_PLAY_END   _IO  ('M', 0x1a)
#define MPUIOC_BLOCK_DELAY      _IO  ('M', 0x1b)
#define MPUIOC_BLOCK_DEMAND     _IOWR('M', 0x1c, mpu_demand_t)

/* the block/unblocking rate is once per beat */
#define MPUIOC_BLOCK_SYNC       _IOR ('M', 0x1d, long)

/* tempo and metronome control */
#define MPUIOC_METRONOME_ON     _IO  ('M', 0x20)
#define MPUIOC_METRONOME_OFF    _IO  ('M', 0x21)

#define MPUIOC_SET_METRONOME    _IOW ('M', 0x22, mpu_metrosetup_t)
#define MPUIOC_GET_METRONOME    _IOR ('M', 0x23, mpu_metrosetup_t)

#define MPUIOC_SET_TIMEBASE     _IOW ('M', 0x24, word)
#define MPUIOC_GET_TIMEBASE     _IOR ('M', 0x25, word)

#define MPUIOC_SET_NUMERATOR    _IOW ('M', 0x26, byte)
#define MPUIOC_GET_NUMERATOR    _IOR ('M', 0x27, byte)

#define MPUIOC_SET_DENOMINATOR  _IOW ('M', 0x28, byte)
#define MPUIOC_GET_DENOMINATOR  _IOR ('M', 0x29, byte)

#define MPUIOC_SET_TEMPO        _IOW ('M', 0x2a, byte)
#define MPUIOC_GET_TEMPO        _IOR ('M', 0x2b, byte)

/*** event handling **********************************************************/

#define MPUIOC_PUT_IMMEDIATE    _IOW ('M', 0x30, midi_event)
#define MPUIOC_PUT_EVENT        _IOW ('M', 0x31, midi_event)

#define MPUIOC_GET_EVENT_SIZE   _IOR ('M', 0x32, long)
#define MPUIOC_GET_EVENT        _IOWR('M', 0x33, midi_event)

#define MPUIOC_GET_QUEUE_DATA   _IOR ('M', 0x21, mpu_queue_t)

/*** SysEx messages sent to MIDI OUT ******************************************/ 

#define MPUIOC_GM_ON            _IO  ('M', 0xe0)
#define MPUIOC_GS_RESET         _IO  ('M', 0xe1)

/*** debug handling ***********************************************************/ 

#define MPUIOC_GET_STATUS       _IOR ('M', 0xf0, mpu_status_t)
#define MPUIOC_SET_DEBUG_LVL    _IOW ('M', 0xf1, word)
#define MPUIOC_GET_DEBUG_LVL    _IOR ('M', 0xf2, word)

#endif /* __MPU_IOCTL_H */

/*** End of File **************************************************************/
