/****************************************************************************** 
 *
 * File:        midifile.h
 * Version:     $Id: midifile.h,v 1.5 1995/08/06 18:02:55 burgaard Exp $
 *
 * Purpose:     Standard MIDI File I/O.
 *
 * Project:     MIDI/Sequencer library.
 * Authors:     Kim Burgaard, <burgaard@daimi.aau.dk>
 * Copyrights:  Copyright (c) 1994 Kim Burgaard.
 *
 *      This package is free software; you can redistribute it and/or modify it
 *      under the terms of the GNU General Public License as published by the
 *      Free Software Foundation; either version 2, or (at your option) any
 *      later version.
 *
 *      This package is distributed in the hope that it will be useful, but
 *      WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *      Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License along
 *      with this program; see the file COPYING. If not, write to the Free
 *      Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************************************
 *
 * Compile and see ../doc/libmidifile.tex for documentation on this file.
 *
 ******************************************************************************/

/*** INCLUDES & DEFINES *******************************************************/

#ifndef __MIDI_FILE_H
#define __MIDI_FILE_H

#include <stdio.h>
#include <unistd.h>

#include "midiqueue.h"
#include "midiconst.h"

/*** GLOBAL VARIABLES *********************************************************/

struct midi_file_data
{
  midi_queue voice; /* They are filled with events when reading and used as source when */
  midi_queue sysex; /* writing. Sorted with respect to time. Notice that tracks are always */
  midi_queue meta;  /* merged when reading */

  char dovoice; /* if non-zero => read/write voice events -- otherwise ignore */
  char dosysex; /* if non-zero => read/write sysex events -- otherwise ignore */
  char dometa;  /* if non-zero => read/write meta events -- otherwise ignore */
};
typedef struct midi_file_data midi_file_data;

struct midi_file_timing
{
  int division;
  int newdivision; 

  /* filled in by the library at read time */
  int mintempo;
  int maxtempo;

  /* if newdivision is non-zero, then the timing information will be rescaled to */
  /* newdivision regardless of the original division */

  long time; /* file total playing time */
};
typedef struct midi_file_timing midi_file_timing;

struct midi_file
{
  FILE  *file; /* user supplied - must be a valid open file with the right permissions */
  char  *name; /* only used when printing evt. error messages */

  char  *title;     /* nonzero and points to a title if one were present at read */
  char  *copyright; /* nonzero and points to a copyright notice if one were present at read */

  int   format; /* Save: Currenly only format 0 is supported. Read: Both 0 and 1 */
  int   tracks; /* The number of tracks read or written */
};
typedef struct midi_file midi_file;

/*** MIDI FILE HANDLING *******************************************************/

/* verb defines verbosity level (see midiprint.h) and the doxxxx parameters indicates */
/* whether the the respective event types should be read or written */

extern int midi_load(midi_file *, midi_file_timing *, midi_file_data *, char verb);
extern int midi_save(midi_file *, midi_file_timing *, midi_file_data *, char verb);

#endif /* __MIDI_FILE_H */

/*** END OF FILE **************************************************************/
