/* Copyright (C) 1991, 1992 Free Software Foundation, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.

   The author may be reached (Email) at the address mike@ai.mit.edu,
   or (US mail) as Mike Haertel c/o Free Software Foundation.  */

#ifndef	_MALLOC_INTERNAL
#define	_MALLOC_INTERNAL
#include "malloc.h"
#endif

/* Allocate an array of NMEMB elements each SIZE bytes long.
   The entire array is initialized to zeros.  */
__ptr_t
calloc (size_t nmemb, size_t size)
{
  register __ptr_t result;
  
#ifdef CHKR_STACKBITMAP
  chkr_check_addr(&nmemb, sizeof(nmemb), CHKR_RO);
  chkr_check_addr(&size, sizeof(size_t), CHKR_RO);
#endif  
  
  result = _malloc (nmemb * size);
  if (result != NULL)
  {
    (void) memset (result, 0, nmemb * size);
#ifdef CHKR_USE_BITMAP
    chkr_set_right (result, nmemb *size, CHKR_RW);
#endif
  }        
  return result;
}
