/*
 *  Project   : tin - a threaded Netnews reader
 *  Module    : inews.c
 *  Author    : I.Lea
 *  Created   : 17-03-92
 *  Updated   : 20-06-92
 *  Notes     : NNTP builtin version of inews
 *  Copyright : (c) Copyright 1991-92 by Iain Lea
 *              You may  freely  copy or  redistribute  this software,
 *              so  long as there is no profit made from its use, sale
 *              trade or  reproduction.  You may not change this copy-
 *              right notice, and it must be included in any copy made
 */

#include	"tin.h"

#if defined(BSD) || defined(RS6000)
#	ifdef apollo
#		include	</bsd4.3/usr/include/netdb.h>
#	else
#		include	<netdb.h>
#	endif
#endif


int submit_inews (name)
	char *name;
{
	int	ret_code = FALSE;

#if !defined(INDEX_DAEMON) && !defined(XSPOOLDIR)

#ifdef NNTP_INEWS
	char	from_name[256];
	char	host_name[128];
	char	line[NNTP_STRLEN];
	FILE	*fp;
	int	len = 0;
	int	respcode;

	if ((fp = fopen (name, "r")) == NULL) {
		return (ret_code);
	}

	/*
	 * Send POST command to NNTP server
	 */
	put_server ("post");

	/*
	 * Receive CONT_POST or ERROR response code from NNTP server
	 */
	if ((respcode = get_respcode ()) != CONT_POST) {
		error_message ("%s", nntp_respcode (respcode));
		debug_nntp ("submit_inews", nntp_respcode (respcode));
		return (ret_code);
	}

	get_host_name (host_name);	
	get_from_name (from_name);
	
	/*
	 * Send Path: and From: article headers
	 */
#ifdef NNTP_INEWS_GATEWAY
	sprintf (line, "Path: %s", userid);
#else
	sprintf (line, "Path: %s!%s", host_name, userid);
#endif	
	put_server (line);
	sprintf (line, "From: %s", from_name);
	put_server (line);

	/*
	 * Send article 1 line at a time ending with "."
	 */
	while (fgets (line, sizeof (line), fp) != NULL) {
		len = strlen (line);
		line[len-1] = '\0';
		fprintf (ser_wr_fp, "%s\r\n", line);
	}
	
	put_server (".");

	/*
	 * Receive OK_POSTED or ERROR response code from NNTP server
	 */
	if ((respcode = get_respcode ()) != OK_POSTED) {
		error_message ("%s", nntp_respcode (respcode));
		debug_nntp ("submit_inews", nntp_respcode (respcode));
		return (ret_code);
  	}
  	
	ret_code = TRUE;

#endif /* NNTP_ABLE */

#endif /* INDEX_DAEMON */

	return (ret_code);
}

/*
 * Find real hostname / substitute hostname if news gateway name 
 */
 
void get_host_name (host_name)
	char *host_name;
{
#ifndef INDEX_DAEMON

	char host[PATH_LEN];

#ifdef NNTP_INEWS_GATEWAY	
	FILE *fp;

	host_name[0] = '\0';

	/*
	 * If 1st letter is '/' read gateway name from specified file
	 */
	if (*(NNTP_INEWS_GATEWAY) == '/') {
		if ((fp = fopen (NNTP_INEWS_GATEWAY, "r")) != (FILE *) 0) {
			if (fgets (host, sizeof (host), fp) != (char *) 0) {
				my_strncpy (host_name, host, strlen (host)-1);
			}	
			fclose (fp);
		}
		if (! host_name[0]) {
			strcpy(host_name, "PROBLEM_WITH_INEWS_GATEWAY_FILE");
		}
	} else {
		strcpy (host_name, NNTP_INEWS_GATEWAY);
	}	
#else
#	if defined(BSD) || defined(sinix) || defined(RS6000) || defined(HPUX)
	{
		struct hostent *host_entry;

		gethostname (host, sizeof (host)); 
		host_entry = gethostbyname (host);
		my_strncpy (host, host_entry->h_name, sizeof (host)); 
	}	
#	else	
	{
		struct utsname uts_name;

		uname (&uts_name);
		my_strncpy (host, uts_name.nodename, sizeof (host));
	}
#	endif

	strcpy (host_name, host);
#endif

#endif /* INDEX_DAEMON */
}

/*
 * Find users & hosts name
 */

void get_from_name (from_name)
	char *from_name;
{
#ifndef INDEX_DAEMON

	char domain[256];
	char full_name[128];
	char host_name[256];
	char *ptr;
#ifdef NNTP_INEWS_DOMAIN
	FILE *fp;
#endif
	
	domain[0] = '\0';
	
	if ((ptr = (char *) getenv ("NAME")) != (char *) 0) {
		my_strncpy (full_name, ptr, sizeof (full_name));
	} else {	
		my_strncpy (full_name, myentry->pw_gecos, sizeof (full_name));
		if ((ptr = (char *) strchr (full_name, ','))) {
			*ptr = '\0';			
		}
	}

	get_host_name (host_name);

#ifdef NNTP_INEWS_DOMAIN
	/*
	 * If 1st letter is '/' read domain name from specified file
	 */
	if (*(NNTP_INEWS_DOMAIN) == '/') {
		if ((fp = fopen (NNTP_INEWS_DOMAIN, "r")) != (FILE *) 0) {
			if (fgets (domain, sizeof (domain), fp) != (char *) 0) {
				if (ptr = (char *) strchr (domain, '\n')) {
					*ptr = '\0';
				}
			}
			fclose (fp);
		}
		if (! domain[0]) {
			strcpy (domain, "PROBLEM_WITH_INEWS_DOMAIN_FILE");
		}
	} else {
		my_strncpy (domain, NNTP_INEWS_DOMAIN, sizeof (domain));
	}
	
	if (domain[0] == '.') {
		sprintf (from_name, "%s@%s%s (%s)",
			userid, host_name, domain, full_name);
	} else {	
		sprintf (from_name, "%s@%s (%s)", userid, domain, full_name);
	}		
#else	
	sprintf (from_name, "%s@%s (%s)", userid, host_name, full_name);
#endif

	if (debug == 2) {
		error_message ("FROM: %s", from_name);
	}	

#endif /* INDEX_DAEMON */
}
