/*
selectnews2.c: provide easy interface for users to hone down their
               .newsrc file

Version: 0.5a

Copyright (C) 1993 Eugene Eric Kim

LAST REVISION: August 6, 1993

SHORTCOMINGS:
-will only help edit what's in .newsrc; cannot
 find new newsgroups not in .newsrc
-uses a mongo array: I didn't feel like playing w/linked lists :)

KEYS:
' ' = switch window
'\n' = select/deselect
'w' = done; write to .newsrc
'q' = quit w/o saving
'k', 'j' = up/down
'f', 'b' = scroll up, scroll down

This version uses the curses library instead of the ncurses.  Arrow
keys do not work in this version.
*/

#include <stdio.h>
#include <curses.h>

#define MAX 600
#define LEN 50

WINDOW *leftscr, *rightscr;

void error(s)
char* s;
{
  fprintf(stderr, s);
  exit(1);
}

FILE* GetFile()
{
  FILE *temp;

  if ( (temp = fopen(".newsrc", "r")) == NULL )
    error("Cannot find .newsrc: make sure you are in your home directory.\n");
  else
    return temp;
}

void Credits()
{
  standout();
  move(LINES-1,0);
  clrtoeol();
  addstr("selectnews * Copyright (C) Eugene Kim 1993 * Press 'i' for instructions");
  standend();
  refresh();
}

void initwin()
{
  initscr();
  noecho();
  cbreak();
  leftscr = newwin(LINES-2,COLS / 2,1,0);
  rightscr = newwin(LINES-2,COLS - (COLS / 2),1,COLS - (COLS / 2));
  scrollok(leftscr,TRUE);
  scrollok(rightscr,TRUE);
  standout();
  mvaddstr(0,0,"UNSUBSCRIBED");
  mvaddstr(0,COLS - (COLS / 2),"SUBSCRIBED");
  standend();
  Credits();
}

void Instructions()
{
  standout();
  move(LINES-1,0);
  clrtoeol();
  addstr("<spc>=switch; <enter>=select; j=down; k=up; w=write; q=quit");
  standend();
  refresh();
}

short Quit()
{
  char ch;

  move(LINES-1,0);
  clrtoeol();
  addstr("Quit without saving? (y/n) ");
  refresh();
  ch = getch();
  if ( (ch == 'y') || (ch == 'Y') )
    return 1;
  else {
    Credits();
    return 0;
  }
}

void cursor(win,loc)
WINDOW *win;
int loc;
{
  mvwaddstr(win,loc,0,"->");
  wrefresh(win);
}

void delcursor(win,loc)
WINDOW *win;
int loc;
{
  mvwaddstr(win,loc,0,"  ");
  wrefresh(win);
}

void showentry(win,b,line)
WINDOW *win;
int b;
char line[LEN];
{
  mvwaddstr(win,b,2,line);
}

void showbuffer(win,buffer,start)
WINDOW *win;
char buffer[MAX][LEN];
int start;
{
  int i = 0;

  werase(win);
  while ((buffer[start+i][0]!='\0') && (i<LINES-2)) {
    showentry(win,i,buffer[start+i]);
    i++;
  }
  wrefresh(win);
}

void deleteline(buffer,i,size)
char buffer[MAX][LEN];
int i,size;
{
  int j,k;
  
  for (j=i; j<size; j++) {
    k = 0;
    do {
      buffer[j][k] = buffer[j+1][k];
      k++;
    } while (buffer[j+1][k]!='\0');
    buffer[j][k]='\0';
  }
  buffer[size][0]='\0';
}

void addline(buffer,last,line)
char buffer[MAX][LEN];
int last;
char line[LEN];
{
  int j = 0;

  do {
    buffer[last][j] = line[j];
    j++;
  } while (line[j]!='\0');
  buffer[last][j] = '\0';
}

void sortfile(f,b1,b2,i,j)
FILE *f;
char b1[MAX][LEN];
char b2[MAX][LEN];
int *i;
int *j;
{
  FILE *backup;
  int ch,c,k;
  char line[LEN];
  short valid, where;  /* 1 = sub; 0 = usub; -1 = trouble */

  if ((backup = fopen(".newsrc.old","w")) == NULL)
    error("Cannot create .newsrc.old.");
  (*i) = (*j) = 0;
  do {
    c = -1;
    where = -1;
    do {
      ch = getc(f);
      if (ch!=EOF) putc(ch,backup);
      if ( (valid=((ch!=' ') && (ch!='\n') && (ch!=EOF))) ) {
        c++;
	line[c] = ch;
	if (ch == ':') where = 1;
	else if (ch == '!') where = 0;
      }
    } while (valid && (where != 1) && (where != 0));
    if (c == -1) c++;
    line[c] = '\0';
    if (line[0]!='\0') {
      if (where == 1) {
	while (getc(f)!='\n') ;
	for (k = 0; k <= c; k++)
	  b1[(*i)][k] = line[k];
	(*i)++;
      }
      else if (where == 0) {
	while (getc(f)!='\n') ;
	for (k = 0; k <= c; k++)
	  b2[(*j)][k] = line[k];
	(*j)++;
      }
      else
	error("Error: .newsrc file corrupt\n");
    }
  } while (ch != EOF);
  fclose(f); /* close .newsrc */
  fclose(backup); /* close backup */
}

int Write(b1,b2)
char b1[MAX][LEN];
char b2[MAX][LEN];
{
  FILE *to;
  int i = 0,j;

  if ( (to=fopen(".newsrc","w")) == NULL)
    error("Can't write .newsrc.");
  while (b1[i][0]!='\0') {
    j = 0;
    while (b1[i][j]!='\0') {
      putc(b1[i][j],to);
      j++;
    }
    putc(':',to);
    putc('\n',to);
    i++;
  }
  i = 0;
  while (b2[i][0]!='\0') {
    j = 0;
    while (b2[i][j]!='\0') {
      putc(b2[i][j],to);
      j++;
    }
    putc('!',to);
    putc('\n',to);
    i++;
  }
  fclose(to);
  return 1;
}

main()
{
  char sub[MAX][LEN], usub[MAX][LEN];
  int ch, i, j, k, c, top1, top2, cc, oc;
  short QUIT = 0;

  /* initialize buffers */
  for (i = 0; i < MAX; i++)
    sub[i][0] = usub[i][0] = '\0';

  /* sort contents of .newsrc */
  sortfile(GetFile(),sub,usub,&i,&j);

  initwin();
  oc = cc = 0;  /* oc=old,cc=current */
  top1 = top2 = 0;
  showbuffer(leftscr,usub,0);
  showbuffer(rightscr,sub,0);
  if (usub[0][0] == '\0') {
    c = 1;
    cursor(rightscr,cc);
  }
  else {
    c = 0;
    cursor(leftscr,cc);
  }

  do {
    ch = getch();
    switch (ch) {
    case 'i': case 'I':
      Instructions();
      break;
    case ' ': case 'h': case 'H': case 'l': case 'L':
    case 0404: case 0405:
      if (c && (usub[0][0] != '\0')) {
	delcursor(rightscr,cc);
	cc = 0;
	cursor(leftscr,cc);
	c = 0;
      }
      else if (!c && (sub[0][0] != '\0')) {
	delcursor(leftscr,cc);
	cc = 0;
	cursor(rightscr,cc);
	c = 1;
      }
      break;
    case 'k': case 'K': case 0403:
      if (c) {
	if (cc) {
	  oc = cc;
	  cc--;
	  delcursor(rightscr,oc);
	  cursor(rightscr,cc);
	}
	else if (top2) { /* cc = 0 */
	  top2--;
	  delcursor(rightscr,cc);
	  wmove(rightscr,0,0);
	  winsertln(rightscr);
	  showentry(rightscr,0,sub[top2]);
	  cursor(rightscr,cc);
	  wrefresh(rightscr);
	}
      }
      else {
	if (cc) {
	  oc = cc;
	  cc--;
	  delcursor(leftscr,oc);
	  cursor(leftscr,cc);
	}
	else if (top1) { 
	  top1--;
	  delcursor(leftscr,cc);
	  wmove(leftscr,0,0);
	  winsertln(leftscr);
	  showentry(leftscr,0,usub[top1]);
	  cursor(leftscr,cc);
	  wrefresh(leftscr);
	}
      }
      break;
    case 'j': case 'J': case 0402:
      if (c) {
	if (sub[top2+cc+1][0] != '\0') {
	  if (cc<LINES-3) {
	    oc = cc;
	    cc++;
	    delcursor(rightscr,oc);
	    cursor(rightscr,cc);
	  }
	  else { /* bottom of screen */
	    top2++;
	    delcursor(rightscr,cc);
	    wmove(rightscr,0,0);
	    wdeleteln(rightscr);
	    showentry(rightscr,cc,sub[top2+cc]);
	    cursor(rightscr,cc);
	    wrefresh(rightscr);
	  }
	}
      }
      else {
	if (usub[top1+cc+1][0] != '\0') {
	  if (cc<LINES-3) {
	    oc = cc;
	    cc++;
	    delcursor(leftscr,oc);
	    cursor(leftscr,cc);
	  }
	  else { /* bottom of screen */
	    top1++;
	    delcursor(leftscr,cc);
	    wmove(leftscr,0,0);
	    wdeleteln(leftscr);
	    showentry(leftscr,cc,usub[top1+cc]);
	    cursor(leftscr,cc);
	    wrefresh(leftscr);
	  }
	}
      }
      break;
    case 'f': case 'F':
      k = LINES - 2;
      if (c) {
	if (sub[top2+k][0]!='\0') {
	  top2 += k;
	  cc = 0;
	  showbuffer(rightscr,sub,top2);
	  cursor(rightscr,cc);
	}
      }
      else {
	if (usub[top1+k][0]!='\0') {
	  top1 += k;
	  cc = 0;
	  showbuffer(leftscr,usub,top1);
	  cursor(leftscr,cc);
	}
      }
      break;
    case 'b': case 'B':
      k = LINES - 2;
      if (c) {
	if (top2) {
	  if (top2-k > 0) 
	    top2 -= k;
	  else
	    top2 = 0;
	  showbuffer(rightscr,sub,top2);
	  cc = 0;
	  cursor(rightscr,cc);
	}
      }
      else {
	if (top1) {
	  if (top1-k > 0) 
	    top1 -= k;
	  else
	    top1 = 0;
	  showbuffer(leftscr,usub,top1);
	  cc = 0;
	  cursor(leftscr,cc);
	}
      }
      break;
    case '\n':
      if (c) {
	addline(usub,j,sub[top2+cc]);
	deleteline(sub,top2+cc,i);
	if (sub[top2+cc][0] == '\0') {
	  if ( (top2 == 0) && (cc == 0) ) {
	    c = 0;
	    cc = 0;
	  }
	  else if ( (top2 != 0) && (cc == 0) ) {
	    if (top2 - LINES - 2 >= 0)
	      top2 -= LINES - 2;
	    else
	      top2 = 0;
	    cc = LINES - 3;
	  }
	  else
	    cc--;
	}
	showbuffer(leftscr,usub,top1);
	showbuffer(rightscr,sub,top2);
	if (c) cursor(rightscr,cc);
	else cursor(leftscr,cc);
	j++;
	i--;
      }
      else {
	addline(sub,i,usub[top1+cc]);
	deleteline(usub,top1+cc,j);
	if (usub[top1+cc][0] == '\0') {
	  if ( (top1 == 0) && (cc == 0) ) {
	    c = 1;
	    cc = 0;
	  }
	  else if ( (top1 != 0) && (cc == 0) ) {
	    if (top1 - LINES - 2 >= 0)
	      top1 -= LINES - 2;
	    else
	      top1 = 0;
	    cc = LINES - 3;
	  }
	  else
	    cc--;
	}
	showbuffer(leftscr,usub,top1);
	showbuffer(rightscr,sub,top2);
	if (c) cursor(rightscr,cc);
	else cursor(leftscr,cc);
	i++;
	j--;
      }
      break;
    case 'q': case 'Q':
      QUIT = Quit();
      break;
    case 'w': case 'W':
      QUIT = Write(sub,usub);
      break;
    default:
      break;
    }
  } while (!QUIT);

  standend();
  clear();
  mvaddstr(0,0,"selectnews");
  mvaddstr(1,0,"version 0.5a");
  mvaddstr(2,0,"Copyright (C) 1993 Eugene Kim");
  mvaddstr(4,0,"Good-bye!\n");
  refresh();
  endwin();
}
