#! /bin/sh
# checkgroups - check active file for missing or extra newsgroups.
#	stdin must a checkgroups news article, sends mail to $NEWSMASTER
#	after updating $nl/newsgroups from $nl/localgroups
# v1.4 of 9/4/84, adapted to C news
# added handling of changes in moderated for groups.  Dan

# =()<. ${NEWSCONFIG-@<NEWSCONFIG>@}>()=
. ${NEWSCONFIG-/usr/local/lib/news/config}
export NEWSCTL NEWSBIN NEWSARTS
PATH=$NEWSCTL/bin:$NEWSBIN:$NEWSPATH ; export PATH
umask $NEWSUMASK

# generate newsgroups from localgroups & stdin
cp $NEWSCTL/localgroups $NEWSCTL/newsgroups
sed '1,/^$/d' >>$NEWSCTL/newsgroups	# behead the article (snuff headers)

# generate list of approved newsgroups from $nl/newsgroups
echo junk >/tmp/$$a
echo control >>/tmp/$$a
# [^.]*\. in next two egreps was net.|mod.|fa., which is inadequate - geoff
sed 's/[ \	].*//' $NEWSCTL/newsgroups |
	egrep "^([^.]*\.|general)" >>/tmp/$$a
sort -u /tmp/$$a -o /tmp/$$a

# generate list of locally-present newsgroups from $nl/active
egrep "^([^.]*\.|general|junk|control)" $NEWSCTL/active |
	sed 's/ .*//' | sort  -u >/tmp/$$b

comm -13 /tmp/$$a /tmp/$$b >/tmp/$$missing
comm -23 /tmp/$$a /tmp/$$b >/tmp/$$remove

egrep "^([^.]*\.|general|junk|control)" $NEWSCTL/active | sed -n "/m\$/s/ .*//p" |
      sort -u > /tmp/$$amod.all
egrep "^([^.]*\.|general)"  $NEWSCTL/newsgroups |
sed -n "/Moderated/s/[ 	][ 	]*.*//p" | sort -u > /tmp/$$ng.mod

comm -12 /tmp/$$missing /tmp/$$ng.mod >/tmp/$$add.mod
comm -23 /tmp/$$missing /tmp/$$ng.mod >/tmp/$$add.unmod
cat /tmp/$$add.mod /tmp/$$add.unmod >>/tmp/$$add

comm -23 /tmp/$$amod.all /tmp/$$remove >/tmp/$$amod
comm -13 /tmp/$$ng.mod /tmp/$$amod >/tmp/$$ismod
comm -23 /tmp/$$ng.mod /tmp/$$amod >/tmp/$$nm.all
comm -23 /tmp/$$nm.all /tmp/$$add >/tmp/$$notmod


if test -s /tmp/$$remove; then
	echo "The following newsgroups are not valid and should be removed."
	sed "s/^/	/" /tmp/$$remove
	echo ""
	echo "You can do this by executing the command:"
	echo "	$NEWSCTL/ctl/rmgroup.auto \\"
	sed 's;.*;		& \\;' /tmp/$$remove
	echo ""
fi 2>&1 >/tmp/$$out

if test -s /tmp/$$add; then
	echo "The following newsgroups were missing." # "and were added."
	sed "s/^/	/" /tmp/$$add
	echo ""
	echo "You can add them by executing the command(s):"
	for i in `cat /tmp/$$add.unmod`
	do
		echo "$NEWSBIN/ctl/newgroup $i </dev/null"
	done
	for i in `cat /tmp/$$add.mod`
	do
		echo "$NEWSBIN/ctl/newgroup $i moderated </dev/null"
	done
	echo ""

#	for i in `cat /tmp/$$add`
#	do
# *** "Subject: cmsg " is a hideous botch of a kludge-hack; avoid it!
#		inews -h <<!
#Control: newgroup $i
#Newsgroups: control
#Subject: newgroup $i
#Distribution: general
#
#Create $i locally.
#!
#	done

fi 2>&1 >>/tmp/$$out

if test -s /tmp/$$ismod;then
	echo "The following newsgroups are not moderated and are marked moderated."
	sed "s/^/	/" /tmp/$$ismod
	echo ""
	echo "You can correct this by executing the command(s):"
	for i in `cat /tmp/$$ismod`
	do
		echo  "$NEWSBIN/ctl/newgroup $i </dev/null"
	done
	echo ""
fi 2>&1 >>/tmp/$$out


if test -s /tmp/$$notmod; then
	echo "The following newsgroups are moderated and not marked so."
	sed "s/^/	/" /tmp/$$notmod
	echo ""
	echo "You can correct this by executing the command(s):"
	for i in `cat /tmp/$$notmod`
	do
		echo "$NEWSBIN/ctl/newgroup $i moderated </dev/null"
	done
	echo ""
fi 2>&1 >>/tmp/$$out


if test -s /tmp/$$out; then
	(echo "Subject: Problems with your active file"; echo "";
	 cat /tmp/$$out) | mail $NEWSMASTER
fi

rm -f /tmp/$$*		# clean up temporaries
