/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)stdio.h	5.3 (Berkeley) 3/15/86
 */

/*
 *	Apollo changes:
 *
 * 01/13/89 smv         enclose NULL in #ifndef NULL
 * 08/26/88 vasta       add perror() declaration
 * 08/16/88 lwa         add _filbuf, _flsbuf decls
 * 02/11/88 garyf       quiet compiler warnings
 * 01/12/88 kfh         alignment mods
 * 09/28/87 rand        Add _NFILE
 * 09/25/87 lwa         Make _bufendtab indexed by _iob index.
 *  9/04/87 mccue       Copied to /usr/include, function prototypes corrected
 *  7/22/87 robinson    Function Prototypes
 *	4/13/87	james_w		Declare sprintf as returning char * .
 *	4/13/87	james_w		Use the same _iob as sys5.3.  Declare all the routines.
 *						Use the same getc and putc macros as sys5.3
 *
 */

/*  Enable function prototypes for ANSI C and C++  */
#if defined(__STDC__) || defined(c_plusplus) || defined(__cplusplus)
#    define _PROTOTYPES
#endif

/*  Required for C++ V2.0  */
#ifdef  __cplusplus
    extern "C" {
#endif

#ifndef FILE
#ifndef _NFILE
#define _NFILE 128
#endif /* _NFILE */
#define	BUFSIZ	1024
extern	struct	_iobuf {
	unsigned char	*_ptr __attribute((aligned(1)));
	short	_cnt;
	unsigned char	*_base __attribute((aligned(1)));
	short	_flag;
	short	_file;
} _iob[];

#define	_IOREAD	01
#define	_IOWRT	02
#define	_IONBF	04
#define	_IOMYBUF	010
#define	_IOEOF	020
#define	_IOERR	040
#define	_IOSTRG	0400
#define	_IOLBF	0100
#define	_IORW	0200

#ifndef NULL
#define	NULL	0
#endif

#define	FILE	struct _iobuf
#define	EOF	(-1)

#define	stdin	(&_iob[0])
#define	stdout	(&_iob[1])
#define	stderr	(&_iob[2])

#define _bufend(p)	(_bufendtab[ ((p) >= &_iob[0] && (p) < &_iob[_NFILE]) ? \
				    ((FILE *)(p) - &_iob[0]) : \
				    _NFILE ] )
#define _bufsiz(p)	(_bufend(p) - (p)->_base)

#  ifndef lint
#define getc(p)		(--(p)->_cnt < 0 ? _filbuf(p) : (int) *(p)->_ptr++)
#  endif /* not lint */
#define	getchar()	getc(stdin)
#  ifndef lint
#    ifndef apollo
#define putc(x, p)	(--(p)->_cnt >= 0 ?\
	(int)(*(unsigned char *)(p)->_ptr++ = (x)) :\
	(((p)->_flag & _IOLBF) && -(p)->_cnt < (p)->_bufsiz ?\
		((*(p)->_ptr = (x)) != '\n' ?\
			(int)(*(unsigned char *)(p)->_ptr++) :\
			_flsbuf(*(unsigned char *)(p)->_ptr, p)) :\
		_flsbuf((unsigned char)(x), p)))
#    else /* is apollo */
#define putc(x, p)	(--(p)->_cnt >= 0 ?\
	(int)(*(unsigned char *)(p)->_ptr++ = (x)) :\
	((((p)->_flag & (_IOLBF | _IOWRT | _IOEOF)) == (_IOLBF | _IOWRT) ) &&\
        -(p)->_cnt < _bufsiz(p) ?\
		((*(p)->_ptr = (x)) != '\n' ?\
			(int)(*(unsigned char *)(p)->_ptr++) :\
			_flsbuf(*(unsigned char *)(p)->_ptr, p)) :\
		_flsbuf((unsigned char)(x), p)))
#    endif /* is apollo */
#  endif /* not lint */
#define	putchar(x)	putc((x),stdout)
#define	feof(p)		(((p)->_flag&_IOEOF)!=0)
#define	ferror(p)	(((p)->_flag&_IOERR)!=0)
#define	fileno(p)	((p)->_file)
#define	clearerr(p)	((void) ((p)->_flag &= ~(_IOERR|_IOEOF)))

extern FILE	_iob[];
extern unsigned char *_bufendtab[];

/* Symbolic constants for the "lseek" routine: */
#define	SEEK_SET	0	/* Set file pointer to "offset" */
#define	SEEK_CUR	1	/* Set file pointer to current plus "offset" */
#define	SEEK_END	2	/* Set file pointer to EOF plus "offset" */

#  ifdef _PROTOTYPES
extern FILE	*fopen(char *filename, char *type);
extern FILE	*fdopen(int filedes, char *type);
extern FILE	*freopen(char *filename, char *type, FILE *stream);
extern FILE	*popen(char *command, char *type);
extern FILE	*tmpfile(void);
extern long	ftell(FILE *stream);
extern void	rewind(FILE *stream);
extern void	setbuf(FILE *stream, char *buf);
extern void	setbuffer(FILE *stream, char *buf, int size);
extern void	setlinebuf(FILE *stream);
extern void     perror(char *s);
extern char	*ctermid(char *s);
extern char	*cuserid(char *s);
extern char	*fgets(char *s, int n, FILE *stream);
extern char	*gets(char *s);
extern char	*tempnam(char *dir, char *pfx);
extern char	*tmpnam(char *s);
extern int	fclose(FILE *stream);
extern int	fflush(FILE *stream);
/* 
following two commented out because it won't compile if redeclared from
what's in an include file (vds 1/6/92 - apollo 6.8 compiler, no-ansi on OS)
extern int	fread(void *ptr, unsigned size, unsigned nitems, FILE *stream);
extern int	fwrite(void *ptr, unsigned size, unsigned nitems, FILE *stream);
*/
extern int	fseek(FILE *stream, long offset, int ptrname);
extern int	fgetc(FILE *stream);
extern int	getw(FILE *stream);
extern int	pclose(FILE *stream);
extern int	printf(char *format, ...);
extern int	fprintf(FILE *stream, char *format, ...);
extern int	vprintf(char *format, ...);
extern int	vfprintf(FILE *stream, char *format, ...);
extern int	vsprintf(char *s, char *format, ...);
extern int	fputc(int c, FILE *stream);
extern int	putw(int w, FILE *stream);
extern int	puts(char *s);
extern int	fputs(char *s, FILE *stream);
extern int	scanf(char *format, ...);
extern int	fscanf(FILE *stream, char *format, ...);
extern int	sscanf(char *s, char *format, ...);
extern int	setvbuf(FILE *stream, char *buf, int type, int size);
extern int	system(char *string);
extern int	ungetc(int c, FILE *stream);
#    if defined(vax) || defined(apollo)
extern char	*sprintf(char *s, char *format, ...);	/* too painful to do right */
#    endif /* vax or apollo */
extern int	_filbuf(FILE *iop);
extern int	_flsbuf(unsigned c, FILE *iop);
#  else /* not _PROTOTYPES */
extern FILE	*fopen(), *fdopen(), *freopen(), *popen(), *tmpfile();
extern long	ftell();
extern void	rewind(), setbuf(), setbuffer(), setlinebuf(), perror();
extern char	*ctermid(), *cuserid(), *fgets(), *gets(), *tempnam(), *tmpnam();
extern int	fclose(), fflush(), fread(), fwrite(), fseek(), fgetc(),
		getw(), pclose(), printf(), fprintf(),
		vprintf(), vfprintf(), vsprintf(), fputc(), putw(),
		puts(), fputs(), scanf(), fscanf(), sscanf(),
		setvbuf(), system(), ungetc();
#    if defined(vax) || defined(apollo)
extern char	*sprintf();		/* too painful to do right */
#    endif
#  endif /* not _PROTOTYPES */
#endif /* not def FILE */

#undef _PROTOTYPES

#ifdef  __cplusplus
    }
#endif

