/*
 *	80x86 I/O functions
 */
 
unsigned char inb(port)
unsigned short port;
{
	unsigned short t=port;
#asm
	mov	ax,dx
	xor	ax,ax
	inb	al,dx
#endasm
}

unsigned char inb_p(port)
unsigned short port;
{
	inb(0x80);
	return inb(port);
}

unsigned char inw(port)
unsigned short port;
{
	unsigned short t=port;
#asm
	xor	ax,ax
	inw	ax,dx
#endasm
}

unsigned char inw_p(port)
unsigned short port;
{
	inw(0x80);
	return inw(port);
}

void outb(port,val)
unsigned short port;
unsigned char val;
{
	unsigned short t=port;
#asm
	mov	ax,dx
	mov	6[bp],al
	outb	dx,al
#endasm
}

void outb_p(port,val)
unsigned short port;
unsigned char val;
{
	inb(0x80);
	outb(port,val);
}

void outw(port,val)
unsigned short port;
unsigned char val;
{
	unsigned short t=port;
#asm
	mov	ax,dx
	mov	6[bp],ax
	outw	dx,ax
#endasm
}

void outw_p(port,val)
unsigned short port;
unsigned char val;
{
	inb(0x80);
	outw(port,val);
}

