/*
 * $Id: ipxroute.h,v 1.1 1995/01/05 09:14:58 root Exp $
 *
 * IPX Router daemon
 */
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <linux/ipx.h>
#include <linux/sockios.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <signal.h>
#include <netinet/in.h>

/*
 * Constants
 */
#define TRUE	1
#define FALSE	0

#define MAXLINELEN	2048
#define STRLEN		64
#define LSTRLEN		256

#ifndef IPXNET_FILE
#define	IPXNET_FILE	"/etc/networks.ipx"
#endif
#ifndef IPXDUMP_FILE
#define IPXDUMP_FILE	"/var/ipx/routes"
#endif

#define MSG_FATAL	0
#define MSG_WARN	1
#define ERR_ERRNO	-1
#define ERR_OK		0

#define MAXNETBUF	65535	/* Max allowed in IPX */

#define IPXT_UNKNOWN	0x00
#define IPXT_RIP	0x01
#define IPXT_SAP	0x04
#define IPXT_SPX	0x05
#define IPXT_NCP	0x11
#define IPXT_NETBIOS	0x14

#define IPXS_DYNAMIC	0
#define IPXS_NCP	0x0451
#define IPXS_SAP	0x0452
#define IPXS_RIP	0x0453
#define IPXS_NETBIOS	0x0455
#define IPXS_DIAG	0x0456
#define IPXS_USER	0x4000
#define IPXS_RESERVED	0x8000

#define IPX_REQ		1
#define IPX_RESP	2

#define IPX_INFINITE_HOPS	17
#define IPX_HOP_LIMIT		16
#define IPX_AGE_LIMIT		60*3
#define IPX_DEL_TIME		1L
#define MAX_IPX_INFO		50
#define IPX_GEN_REQ		0xffffffffL
/*
 * Data Types
 */
typedef int BOOL;

/*
 * Structures
 */
typedef struct _IPXRouteEnt {
  unsigned long		network;	/* Remote network */
  unsigned long		rnetwork;	/* Router network */
  unsigned char		rnode[6];	/* Router node */
  unsigned short	hops;
  unsigned short	ticks;
  unsigned long		age;
  int	       		frame;		/* Frame type */
  struct _IPXRouteEnt	*next;
} IPXRouteEnt;

typedef struct {
  unsigned long		network;
  unsigned short	hops;
  unsigned short	ticks;
} IPXRipEnt;

/*
 * Functions
 */
void sysMsg(int lvl,int errno,char *fmt,...);
int parse(char *buf,char **argtab,char *z);
char *getline(char *str,int cnt,FILE *fp);
int asc2frame(char *frame);
unsigned long gethex(char *asc);
unsigned long ipx_getipxaddr(unsigned char *node,char *str);

IPXRouteEnt *add_local_route(char *dev,int frame,unsigned long net,IPXRouteEnt *table);
void broadcast_ipx(unsigned char iobuf[],unsigned long network,
		   unsigned port,int type,int size);
void broadcast_rip(IPXRouteEnt *rtes);
void send_ripinfo(IPXRouteEnt *rtes,unsigned long net);
void down_local_route(char *dev,int frame,unsigned long net);
int opensock(unsigned int port,int type);
IPXRouteEnt *read_rip(int sock,IPXRouteEnt *rtes);
IPXRouteEnt *findRoute(unsigned long net,IPXRouteEnt *p);
IPXRouteEnt *delRoute(IPXRouteEnt *todel,IPXRouteEnt *net);
void down_route(IPXRouteEnt *p);
IPXRouteEnt *new_route(IPXRouteEnt *net,unsigned long xnet,int hops,int ticks,
		       unsigned char *node);
void general_request(int);
void process_req(struct sockaddr_ipx *sk,IPXRipEnt *,int ,IPXRouteEnt *rtes);
IPXRouteEnt *age_rip(IPXRouteEnt *);
IPXRouteEnt *maxhop_rip(IPXRouteEnt *);
void dump_ipxtab(IPXRouteEnt *rtes);
void display_ipxtab(IPXRouteEnt *rtes);
void write_ipx(struct sockaddr_ipx *skp,unsigned char iobuf[],int size);
char *ipx_ntoa(unsigned char *node);

extern IPXRouteEnt *net_table;
extern int verbose;


