#include <sys/types.h>
#include <stdio.h>
#include <ctype.h>
#include <dirent.h>
#include <errno.h>
#include <fcntl.h>
#include <pwd.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <termios.h>
#include <unistd.h>
#define __ARGS(x) x
#include "buildsaddr.h"


extern int Make_Connection(const int,const char *);

int sockfd= -1;

static int connect_to(const char *address, int port)
{
	return(Make_Connection(port,address));
}

void net_init()
{
	;
}

int net_sendline(const char *buf)
{
#ifdef TRACE_POP
	printf(">%s",buf);
#endif
	if(write(sockfd,buf,strlen(buf))!=strlen(buf))
        {
        	perror("sendline");
        	return(-1);
        }
	return(0);
}

int net_connect(const char *host)
{
	sockfd=connect_to(host,110);
	if(sockfd==-1)
		return(-1);
	return(0);
}

void cause_int()
{
	;
}

int net_getline(char *buf,int len,long timeout)
{
	int got=0;
	int err;
	signal(SIGALRM,cause_int);
	alarm(timeout);
	while(1)
	{
		if(got==len)
			return(-2);
		err=read(sockfd,&buf[got],1);
		if(err!=1)
		{
			perror("getline");
			if(errno!=EINTR)
				return(-1);
			return(-3);
		}
		if(buf[got]=='\n')
		{
			if(got>0 && buf[got-1]=='\r')
				buf[got-1]=0;
			else
				buf[got]=0;
#ifdef TRACE_POP
			printf("<%s\n",buf);
#endif
			return(0);
		}
		got++;
	}
}
