#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <string.h>
#include <arpa/telnet.h>
#include "bb.h"

#define FALSE 	0
#define TRUE	!FALSE

extern char *mw_fgets();

#define min(a,b) a<b?a:b
#define max(a,b) a>b?a:b

int stringcmp(char *a, char *b, int n)
{
	int length,i;
	char c[81],d[81];
	
	if (n==-1) /* total match */
		length=max(strlen(a),strlen(b));
	else
	if (n==-2) /* first partial match */
	{
		length=min(strlen(a),strlen(b));
	} else /* match by atleast n (or shortest string) */
	{
		if (strlen(a)<n) return(FALSE);
		length=strlen(a)>strlen(b)?strlen(a):strlen(b);
		length=n<length?n:length;
	}
	if (length==0) return(FALSE);
	for (i=0;i<length;i++)
	{
		c[i]=islower(a[i])?toupper(a[i]):a[i];
		d[i]=islower(b[i])?toupper(b[i]):b[i];
	}
	if (!strncmp(c,d,length)) 
		return(TRUE);
	else 
		return(FALSE);
}


static char stackedline[256];
static int stacked=0;

void stack_str(char *string)
{
	strcpy(stackedline,string);
	stacked=1;
}

int is_stacked()
{
	return(stacked);
}

int eof_caught=0;

void get_str(char *string, int size)
{
	char *ptr;
	if(stacked==1)
	{
		strncpy(string,stackedline,size);
		stackedline[size]=0;
		stacked=0;
		if ((ptr=(char *)strchr(string,'\n'))!=NULL) 
			*ptr=0;
	}
	else
	{
		fflush(stdout);
		mw_fgets(string,size+1,stdin);
		if (feof(stdin)) 
		{
			eof_caught++;
			if (eof_caught>=3)
			{
				exit(0);
			}
			clearerr(stdin);
		}else
			eof_caught=0;
		if ((ptr=(char *)strchr(string,'\n'))!=NULL) 
			*ptr=0;
		else
		{
			read2cr();
		}
		if(strchr(string,'\r')!=NULL)
			*strchr(string,'\r')=0;
	}
}

void read2cr(void)
{
	int c;
	while ((c=getachar())!=EOF && c!='\n');
}	

int getachar(void)
{
	int c;
	fflush(stdout);
	fflush(stderr);
	c=getchar();
	while (c==255)
	{
		getchar();
		getchar();
		c=getchar();
	}
	return(c);
}
	

void strip_str(char *string)
{
	char *array;
	int i,ptr=0;
	int len;
	
	len=strlen(string);
	array=(char *)malloc(len+1);
	for (i=0;i<len;i++)
	{
		if (isprint(string[i]))
			array[ptr++]=string[i];
	}
	array[ptr]=0;
	strcpy(string,array);
	free(array);
}




/* common file functions */

char *makepath(char *a, char *b, char *c)
{
	static char fullpath[PATHSIZE];

	sprintf(fullpath,"%s/%s%s%s",HOMEPATH,a,b,c);
	return(fullpath);
}
		
int openfolderfile(int mode)
{
	int x;
	x=open(makepath(FOLDERFILE,"",""),mode);
	if (x<0)
	{
		perror("Open Folder File");
		exit(-1);
	}
	return(x);
}

int nofolders(void)
{
	return(access(makepath(FOLDERFILE,"",""),00));
}

int openuserfile(int mode)
{
	int x;
	x=open(makepath(USERFILE,"",""),mode);
	if (x<0)
	{
		perror("Open User File");
		exit(-1);
	}
	return(x);
}

int openwhofile(int mode)
{
	int x;
	x=open(makepath(WHOFILE,"",""),mode);
	if (x<0)
	{
		perror("Open Who File");
		return(-1);
	}
	return(x);
}

int err_open(char *path,int type,int mode)
{
	int x;
	x=open(path,type,mode);
	if (x<0)
		perror(path);
	return(x);
}

char *mw_fgets(char *string,int size, FILE *fp)
{
	int ct=0;
	int ch;
	if(fp!=stdin || internet==0)
		return fgets(string,size,fp);

	while(ct<size)
	{
		ch=getchar();
		if(ch==EOF)
			return(NULL);
		if(ch==IAC)
		{
			ch=getachar();
			switch(ch)
			{
				case EOF:return(NULL);
				case WILL:;
				case WONT:;
				case DO:;
				case DONT:
					getchar();
					continue;
				case EC:
					if(ct>0) ct--;
					break;
				case EL:
					ct=0;
					break;
			}
		}
		else
		{
			if(ch==8 || ch==127)
			{
				if(ct>0) ct--;
			}
			else
				string[ct++]=ch;
		}
		if(ch=='\r')
			ct--;
		if(ch=='\n')
			return(string);
	}
	return(string);
}
