/*********************************************************
 *     The Milliways III System is copyright 1992        *
 *      J.S.Mitchell. (arthur@sugalaxy.swan.ac.uk)       *
 *       see licence for furthur information.            *
 *********************************************************/

#include <fcntl.h>
#include <errno.h>

#define LOCK_IT		1
#define UNLOCK_IT	0

void Lock_File(int f)
{
	long position=lseek(f,0,1);
	if(position==-1)
	{
		perror("ltell");
		exit(1);
	}
	if(lseek(f,0,0)==-1)
	{
		perror("rewind");
		exit(1);
	}
	while(lockf(f,LOCK_IT,1))
	{
		if(errno!=EINTR)
		{
			perror("flock");
			exit(-1);
		}
	}
	if(lseek(f,position,0)==-1)
	{
		perror("seekback");
		exit(-1);
	}
}

void Unlock_File(int f)
{
	long position=lseek(f,0,1);
	if(position==-1)
	{
		perror("ltell");
		exit(1);
	}
	if(lseek(f,0,0)==-1)
	{
		perror("rewind");
		exit(1);
	}
	while(lockf(f,UNLOCK_IT,1))
	{
		if(errno!=EINTR)
		{
			perror("flock");
			exit(-1);
		}
	}
	if(lseek(f,position,0)==-1)
	{
		perror("seekback");
		exit(-1);
	}
}
