#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

#include "Parse.h"
extern unsigned long rights;
extern CommandList table[];

static inline void shuffle_up(char *bp)
{
	/* The strlen is right its the length of bp, which is the length
	   of bp+1 including the NUL */
	memmove(bp,bp+1,strlen(bp));
}

int ParseLine(char *line, char *argv[])
{
	char *ptr=line;
	int n=0;
	int quoted=0;
	int slashed=0;
	
	while(n<MAX_ARGC-1)
	{
/*		printf("Skip spaces on [%s...]\n",ptr);*/
		while(*ptr && isspace(*ptr))
			ptr++;
		if(*ptr==0)
			break;
		argv[n++]=ptr;
/*		printf("Begin process entry %d [%s...]\n",n, ptr);*/
		while(*ptr && (!isspace(*ptr) || quoted || slashed))
		{
			if(slashed==1)
			{
				ptr++;
				slashed=0;
				continue;
			}
			if(*ptr=='\\')
			{
				slashed=1;
				shuffle_up(ptr);
				continue;
			}
			if(*ptr=='"')
			{
				quoted=1-quoted;
				shuffle_up(ptr);
				continue;
			}
			ptr++;
		}
		if(*ptr)
			*ptr++=0;
	}
	argv[n]=NULL;
	return n;
}


int BoolOpt(const char *n)
{
	if(strlen(n)==1)
	{
		if(*n=='Y' || *n=='y')
			return 1;
		if(*n=='n' || *n=='N')
			return 0;
	}
	if(strcasecmp(n,"on")==0)
		return 1;
	if(strcasecmp(n,"yes")==0)
		return 1;
	if(strcasecmp(n,"off")==0)
		return 0;
	if(strcasecmp(n,"no")==0)
		return 0;
	return -1;
}


int DoCommand(char *input, const CommandList *cm)
{
	char *argv[MAX_ARGC];
	int argc=ParseLine(input,argv);
	int inlen=strlen(argv[0]);
	CommandList *found=NULL, *exact=NULL;
	int count=0, ecount=0;
	int c;
	
	/*
	 *	No input
	 */
	 
	if(argc==0)
		return 0;
		
	/*
	 *	Find command
	 */
	 
	while(cm->Command)
	{
		if ((c=command_compare(argv[0], cm->Command))==inlen && (rights&cm->Rights)==cm->Rights)
		{
			if (c==strlen(cm->Command))  /* is it exact */
			{
				if (exact==NULL) /* first exact */
				{
					ecount=1;
					exact=cm;
				}else /* another exact (panic) */
					ecount++;
			}else /* partial match */
			{
				if (found==NULL)  /* first one */
				{
					found=cm;
					count=1;
				}else
				if (ecount!=1)  /* another, and no exact match */
				{
					if (count==1) /* 2nd one */
					{
						printf("Ambiguous command. Possibilities:-\n");
						printf("%s, %s",found->Command, cm->Command);
					}else /* more */
						printf(", %s",cm->Command);	
					count++;
				}
			}

		}
	 	cm++;
	}

	if (ecount>1)
	{
		printf("ERROR: There are more than one commands with that exact name.\n");
		printf("       Please report this error.\n");
		return 0;
	}else
	if (count>1 && ecount==0)
	{
		printf("\nPlease be more specific\n");
		return 0;
	}else
	if (ecount==1)
	{
		if(argc<exact->Args+1)
		{
			printf("%s\n",exact->ArgError);
			return 0;
		}
		/* return */ exact->Function(exact,argc,argv);
		return 1;
	}else	
	if (count==1)
	{
		if(argc<found->Args+1)
		{
			printf("%s\n",found->ArgError);
			return 0;
		}
		/* return */ found->Function(found,argc,argv);
		return 1;
	}
	printf("Command not found\n");
	return -1; /* Beats me */
}


void InitParser(void)
{
}

#define min(a,b)  a<b?a:b

int command_compare(char *input, char *comm)
{
	int a=strlen(input);
	int b=strlen(comm);
	int c=0;
	int len=min(a,b);

	if (len==0) return(0);

	while (input[c]==comm[c] && c<len) c++;
	return(c);
}
	
void help_list(void)
{
	CommandList *c=table;	
	int count;
	char buff[10];

	count=0;
	printf("Available commands:-\n");
	while (c->Command)
	{
		if ((rights&c->Rights)==c->Rights)
		printf("%20s - %s\n",c->Command,c->Desc);
		c++;
		count++;
		if (count>=22)
		{
			printf("---more---\r");
			gets(buff);
			printf("          \r");
			if (*buff=='q' || *buff=='Q') return;
			count=0;
		}
	}
}
