/*	xdip.c
 *	Copyright Bo Yang, 1995
 *
 */

#define MYDIP "/etc/script.dip"

#ifdef ISC
#include <sys/bsdtypes.h> /* Saul */
#endif

#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <string.h>
#include <sys/wait.h>
#include <sys/time.h>
#if defined ___AIX || defined _AIX || defined __QNX__ || defined ___AIXV3 || defined AIXV3 || defined _SEQUENT_
#include <sys/select.h>
#endif

#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>

#include <X11/Xlib.h>
#include <X11/xpm.h>

#include "xdip_down.xpm"
#include "xdip_dial.xpm"
#include "xdip_up.xpm"

typedef struct _XpmIcon {
    Pixmap pixmap;
    Pixmap mask;
    XpmAttributes attributes;
}        XpmIcon;

#define FALSE 0

/**************************************************************************
 * A few function prototypes 
 **************************************************************************/
void RedrawWindow( XpmIcon *v);
void GetXPM(void);
Pixel GetColor(char *name);
int flush_expose (Window w);
void dial( int cmd);
int net_up(int netst);

time_t t0 = -1;

XpmIcon view_down, view_dial, view_up;
Window win;

Display *dpy;			/* which display are we talking to */
Window Root;
int screen;
int x_fd;
int d_depth;
int ScreenWidth, ScreenHeight;
XSizeHints mysizehints;
Pixel back_pix, fore_pix;
GC NormalGC;
pid_t pd;

#define NET_DOWN	0
#define NET_DIAL	1
#define NET_HANG	2
#define NET_UP		3

#define MW_EVENTS   (ExposureMask | ButtonPressMask | StructureNotifyMask)

/****************************************************************************
 *
 * Creates an icon window as needed
 *
 ****************************************************************************/
int main(int argc, char **argv)
{
  char *display_name = NULL;
  int retval, net_state, auto_redial = 0;
  XGCValues gcv;
  unsigned long gcm;
  XEvent Event;
  XTextProperty name;
  fd_set in_fdset;
  int fd_width ;
  time_t t;
  struct itimerval value;
  int fd[2];
  char *wname = "xdip";
  XpmIcon *v;


#ifndef NO_SYSCONF
  fd_width = sysconf(_SC_OPEN_MAX);
#else
  fd_width = getdtablesize();
#endif

  /* Open the display */
  if (!(dpy = XOpenDisplay(display_name))) 
    {
      fprintf(stderr,"xdip: can't open display %s",
	      XDisplayName(display_name));
      exit (1);
    }
  screen= DefaultScreen(dpy);
  Root = RootWindow(dpy, screen);
  d_depth = DefaultDepth(dpy, screen);
  x_fd = XConnectionNumber(dpy);

  ScreenHeight = DisplayHeight(dpy,screen);
  ScreenWidth = DisplayWidth(dpy,screen);

  /* Get the xpm banner */
  GetXPM();

  /* Create a window to hold the banner */
  mysizehints.flags= USSize|USPosition;
  mysizehints.width = view_down.attributes.width;
  mysizehints.height=view_down.attributes.height;

  mysizehints.x = ScreenWidth - view_down.attributes.width-8;
  mysizehints.y = -10- view_down.attributes.height;

  back_pix = GetColor("white");
  fore_pix = GetColor("black");

  win = XCreateSimpleWindow(dpy,Root,mysizehints.x,mysizehints.y,
				 mysizehints.width,mysizehints.height,
				 1,fore_pix,back_pix);

  XSelectInput(dpy,win,MW_EVENTS);

  if (XStringListToTextProperty(&wname, 1, &name) ==0) {
	fprintf(stderr, "xdip: can't allocate window name\n");
	exit(-1);
  }
  XSetWMName(dpy, win, &name);

  /* Create a GC for drawing */
  gcm = GCForeground|GCBackground|GCGraphicsExposures;
  gcv.foreground = fore_pix;
  gcv.background = back_pix;
  gcv.graphics_exposures = FALSE;
  NormalGC = XCreateGC(dpy, Root, gcm, &gcv);  

  XMapWindow(dpy,win);
  net_state = net_up(NET_DOWN)?NET_UP:NET_DOWN;
  v = net_up(net_state)? &view_up: &view_down;
  value.it_value.tv_usec = 0;
  value.it_value.tv_sec = 1;
  while(1)
    {
      FD_ZERO(&in_fdset);
      FD_SET(x_fd,&in_fdset);

      if(!XPending(dpy))
#ifdef __hpux
	retval=select(fd_width,(int *)&in_fdset, 0, 0, &value.it_value);
#else
	retval=select(fd_width,&in_fdset, 0, 0, &value.it_value);
#endif
      if(FD_ISSET(x_fd, &in_fdset))
	{
	  /* read a packet */
	  XNextEvent(dpy,&Event);
	  switch(Event.type)
	    {
	    case Expose:
	      if(Event.xexpose.count == 0)
		RedrawWindow(v);
	      break;
	      
	    case ButtonPress:
		switch( net_state) {
		    case NET_DOWN:
			net_state = NET_DIAL;
			dial(net_state);
			break;
		    case NET_DIAL:
			net_state = NET_DOWN;
			dial(net_state);
			break;
		    case NET_UP:
			net_state = NET_HANG;
			dial(net_state);
			break;
		}
	        retval = 0;		/* force an update */
	      break;
	    case DestroyNotify:
		exit(0); 
	    default:
	      break;      
	    }
	}
	if( retval == 0) {		/* time out */
	    switch( net_state) {
		case NET_DOWN:
		    value.it_value.tv_sec = 1000000;	/* a big number */
		    break;
		case NET_DIAL:
		    if( net_up(net_state)) {
			v = &view_up;
			net_state = NET_UP;
			XBell(dpy, 100);
		    }
		    else if( kill(pd, 0) <0) {	/* dip failed */
			net_state = NET_DOWN;
			v = &view_down;
		    } else {		/* still dialing */
			 if( v == &view_down) v = &view_dial;
			 else v = &view_down;		/* animation, dude! */
		    }
		    RedrawWindow( v);
		    value.it_value.tv_sec = 1;	
		    break;
		case NET_HANG:
		    if( !net_up(net_state)) {
			v = &view_down;
			net_state = NET_DOWN;
		    }
		    else if( v == &view_up) v = &view_dial;
		    else v = &view_up;		
		    value.it_value.tv_sec = 1;	
		    RedrawWindow( v);
		    break;
		case NET_UP:
			/* checking if dip is still up */
		    if( !net_up(net_state) ) {
			if( auto_redial) {
			    net_state = NET_DIAL;
			    dial(net_state);
			    v = &view_dial;
			    value.it_value.tv_sec = 1;	
			}
			else {
			    net_state = NET_DOWN;
			    v = &view_down;
			    value.it_value.tv_sec = 10000000;/* a big number */
			}
			RedrawWindow (v);
		    }
		    else 
			value.it_value.tv_sec = 2;	
	        }
	    }
    }
  return 0;
}

/****************************************************************************
 *
 * Draws the icon window
 *
 ****************************************************************************/
void RedrawWindow( XpmIcon *v)
{
    flush_expose (win);
  XCopyArea(dpy,v->pixmap,win,NormalGC,
	    0,0,v->attributes.width, v->attributes.height,0,0);

}


/****************************************************************************
 *
 * Looks for a color XPM icon file
 *
 ****************************************************************************/
void GetXPM(void)
{
  view_down.attributes.valuemask |= XpmReturnPixels;
  view_down.attributes.valuemask |= XpmReturnExtensions;
  view_dial.attributes.valuemask |= XpmReturnPixels;
  view_dial.attributes.valuemask |= XpmReturnExtensions;
  view_up.attributes.valuemask |= XpmReturnPixels;
  view_up.attributes.valuemask |= XpmReturnExtensions;
  if(XpmCreatePixmapFromData(dpy, Root, xdip_down_xpm,
			     &view_down.pixmap, &view_down.mask,
			     &view_down.attributes)!=XpmSuccess
   ||XpmCreatePixmapFromData(dpy, Root, xdip_dial_xpm,
			     &view_dial.pixmap, &view_dial.mask,
			     &view_dial.attributes)!=XpmSuccess
   ||XpmCreatePixmapFromData(dpy, Root, xdip_up_xpm,
			     &view_up.pixmap, &view_up.mask,
			     &view_up.attributes)!=XpmSuccess)

    exit(1);
}

void nocolor(char *a, char *b)
{
 fprintf(stderr,"xdip: can't %s %s\n", a,b);
}


/****************************************************************************
 * 
 * Loads a single color
 *
 ****************************************************************************/ 
Pixel GetColor(char *name)
{
  XColor color;
  XWindowAttributes attributes;

  XGetWindowAttributes(dpy,Root,&attributes);
  color.pixel = 0;
   if (!XParseColor (dpy, attributes.colormap, name, &color)) 
     {
       nocolor("parse",name);
     }
   else if(!XAllocColor (dpy, attributes.colormap, &color)) 
     {
       nocolor("alloc",name);
     }
  return color.pixel;
}


/**************************************************************************
 *
 * Removes expose events for a specific window from the queue 
 *
 *************************************************************************/
int flush_expose (Window w)
{
  XEvent dummy;
  int i=0;
  
  while (XCheckTypedWindowEvent (dpy, w, Expose, &dummy))i++;
  return i;
}

void dial( int cmd)
{
char *args[3];
int status;

    if( cmd == NET_DOWN) {
	kill( pd, SIGTERM);
	waitpid(pd, &status, WNOHANG);
	return;
    }
    pd = fork();
    if( pd >0) 
	/* still xdip */
	return;
    else if( pd ==0) {
	/* child */
	args[0] = "dip";
	if( cmd == NET_DIAL)
	    args[1] = MYDIP;
	else if( cmd == NET_DOWN)
	    return;
	else if( cmd == NET_HANG)
	    args[1] = "-k";
	else {
	    fprintf(stderr, "xdip:dial can't understand the command\n");
	    exit(-1);
	}
	args[2] = 0;
	execvp( args[0], args);
	fprintf(stderr, "xdip:Can't execute command %s %s\n", args[0], args[1]);
	exit(-1);
    } else {
	fprintf(stderr, "xdip:No more forks for me");
	exit(-1);
    }
}

int net_up(int netst)
{
static int dippid = 0;
int rt;
FILE *fp;

    if( !dippid || netst == NET_DIAL || netst == NET_HANG) {
	if( (fp = fopen( "/etc/dip.pid", "r")) == NULL) 
	    return(0);
	fscanf(fp, "%d", &dippid);
	fclose (fp);
    }
    if( (rt = kill( dippid, 0)) <0)
	dippid = 0;
    return( rt ==0);
}
	
