/* strntest.c - test some 'strn' functions */

#include <stdio.h>
#include <string.h>

char buf[1024];

main()
{
#ifndef STRNCPY_0_BAD		/* original Minix strncpy crashes if this is
				   run */
    mcpy(buf, "target", 7);
    strncpy(buf, "source", 0);
    if (mcmp(buf, "target", 7) != 0)
	oops("strncpy", "zero counts", "");
#endif

    mcpy(buf, "target", 7);
    strncpy(buf, "source", 4);
    if (mcmp(buf, "souret", 7) != 0)
	oops("strncpy", "small counts", " (extra null terminator?)");

    mcpy(buf, "target", 7);
    strncpy(buf, "sour", 7);
    if (mcmp(buf, "sour\0\0", 7) != 0)
	oops("strncpy", "large counts", " (no null padding?)");

    mcpy(buf, "target", 7);
    strncat(buf, "source", 0);
    if (mcmp(buf, "target", 7) != 0)
	oops("strncat", "zero counts", "");

    mcpy(buf, "target\0ource", 6 + 7);
    strncat(buf, "source", 4);
    if (mcmp(buf, "targetsour\0\e", 7 + 6) != 0)
	oops("strncat", "small counts", " (extra null terminator?)");

    if (strncmp("left", "right", 0) != 0)
	oops("strncmp", "zero counts", "");
}

/* don't trust library functions for checking */

mcmp(left, right, nbytes)
register char *left;
register char *right;
size_t nbytes;
{
    while (nbytes-- != 0)
	if (*left++ != *right++)
	    return left[-1] - right[-1];
    return 0;
}

mcpy(target, source, nbytes)
register char *target;
register char *source;
size_t nbytes;
{
    while (nbytes-- != 0)
	*target++ = *source++;
}

oops(function, bug, possibility)
char *function;
char *bug;
char *possibility;
{
    printf("%s doesn't handle %s properly%s\n", function, bug, possibility);
}
