/* memsettest.c - test memset() */

#include <stdio.h>
#include <string.h>

#define NALIGN 4
#define NCOUNT 1024

size_t count;
char *result;
char t[NCOUNT + NALIGN];
size_t talign;

main()
{
    register size_t i;

    for (count = 0; count < NCOUNT; ++count)
    {
	for (talign = 0; talign < NALIGN; ++talign)
	{
	    for (i = 0; i < sizeof t; ++i)
		t[i] = 0;
	    result = memset(t + talign, (char) count, count);
	    if (result != t + talign)
		error("bad result", 0);
	    if ((i = memnzero(t, talign)) != 0)
		error("target undershot", i);
	    if ((i = memnset(t + talign, (char) count, count)) != 0)
		error("target not filled right", i);
	    if ((i = memnzero(t + talign + count,
			      sizeof t - talign - count)) != 0)
		error("target overshot", i);
	}
    }
}

error(s, i)
char *s;
size_t i;
{
    printf("%s, count = %u, char = %u, talign = %u, index = %u\n",
	   s, count, (char) count, talign, i);
    for (i = 0; i < sizeof t; ++i)
	printf("%2u", t[i]);
    printf("\n");
}

memneq(s1, s2, count)
char *s1;
register char *s2;
register size_t count;
{
    register char *rs1;

    rs1 = s1;
    while (count--)
	if (*rs1++ != *s2++)
	    return rs1 - 1 - s1;
    return 0;
}

memnset(s, ch, count)
char *s;
char ch;
register size_t count;
{
    register char *rs;

    rs = s;
    while (count--)
	if (*rs++ != ch)
	    return rs - 1 - s;
    return 0;
}

memnzero(s, count)
char *s;
register size_t count;
{
    register char *rs;

    rs = s;
    while (count--)
	if (*rs++ != 0)
	    return rs - 1 - s;
    return 0;
}
