#define MAXUSER	32


struct _Packet
{
	short pk_Flag;		/* Control info on packets */
	short pk_User;
	char pk_Line[128];
};

typedef struct _Packet M_PACKET;

struct PkHead
{
	short pk_Current;
};

struct _User
{
	char us_Name[32];
	char us_UserName[8];
	short us_Flags;
	char us_Channel[16];
};

#define UF_USED		1	/* Slot allocated */
#define UF_LOGIN	2

/*
 *	This structure represents the entire shared memory segment
 */
 
struct HighSegment	
{
	struct PkHead hs_Header;	/* Message header */
	struct _User hs_Users[MAXUSER];	/* All the people */
	struct _Packet hs_Data[200];	/* Cyclic Buffers */
	short  hs_Magic;
};

typedef struct HighSegment HISEG;


#define RUN_MAGIC	0x7521
#define CRASH_MAGIC	0x0dea
