#include "str.h"

procedure insert(source : string; var s : string; index : integer);
var
    slen : integer;
    srclen : integer;
    preflen : integer;
    remlen : integer;
    tmp : string;
begin
slen := length(s);
preflen := index - 1;
if (preflen <= slen) and (preflen >= 0) then
    begin
    tmp := copy(s, 1, preflen);   { copy prefix from s }

    srclen := length(source);
    if srclen + preflen > strlen then
	srclen := strlen - preflen;   { source would overflow }
    tmp := tmp + copy(source, 1, srclen);  { copy inserted text }

    remlen := slen - preflen;
    if length(tmp) + remlen > strlen then
        remlen := strlen - length(tmp);   { remainder would overflow }
    tmp := tmp + copy(s, preflen+1, remlen);  {copy suffix from s}

    s := tmp;
    end;
{ else - leave s unchanged if index invalid }
end; { insert }


procedure delete(var s:string; index : integer; count : integer);
var
    tmp : string;
    slen : integer;
begin
tmp := s;
slen := length(s);
if (index <= slen) and (index > 0) and (count > 0) then
    begin
    s := substr(tmp,1,index-1);
    if slen >= index + count then
	s := s + substr(tmp, index + count, slen - index - count + 1);
    end
end;

function pos(sub, s : string) : integer;
var
   i, sublen, slen : integer;
   res : integer;
begin
res := 0;
sublen := length(sub);
slen := length(s);
i := 1;
while (i + sublen - 1 <= slen) and (res = 0) do
    begin
    if substr(s, i, sublen) = sub then
	res := i;
    i := i + 1;
    end;
pos := res;
end;

function copy(s : string; index : integer; count : integer) : string;
var
    slen : integer;
begin
slen := length(s);
if (index > slen) then
    copy := ''
else
    begin
    if index + count - 1 > slen then
        count := slen - index + 1;
    copy := substr(s, index, count);
    end;
end;

function ctos(ch : char) : string;
var
    sub : string;
begin
sub := 'A';
sub[1] := ch;
ctos := sub;
end;


#define INT_MIN (-maxint - 1)

procedure valint(s:string; var i, code:integer);
var
    result : integer;
    next_digit : integer;
    negative : boolean;	
    j : integer;
begin
result := 0;
negative := false;
j := 1;

{ Skip leading blanks }
while (j <= length(s)) and (s[j] = ' ') do
   j := j + 1;

{ handle minus sign }
if (j <= length(s)) and (s[j]  = '-') then
    begin
    negative := true;
    j := j + 1;
    end;

{ build up number as a -ve number (so INT_MIN can be
  represented) being careful to check for overflow }
code := 0;
while (j <= length(s)) and (code = 0) do
    begin    
    if s[j] in ['0'..'9'] then
	begin
	next_digit := ord(s[j]) - ord('0');
	if result < (INT_MIN + next_digit) / 10 then
		code := j    /* overflow on digit j */
	else
		result := -next_digit + 10 * result;
	end
    else
        code := j;
    j := j + 1;
    end;

if code = 0 then
    begin
    if not negative then
	if -maxint > result then
	    code := j - 1	/* overflow */
	else
	    i := -result
    else
        i := result
    end
else
    i := 0;
end;


procedure strint(x, width : integer; var s : string);
var
    workstr : string;
    start : integer;
    negative : boolean;
    len : integer;
    i : integer;
begin
if (width < 1) or (width > strlen) then
    width := 1;

if (x < 0) then
    begin
    negative := true;
    x := -x;
    end
else
    negative := false;

start := strlen;
if x = 0 then
   begin
   workstr[start] := '0';
   start := start-1;
   end
else
    begin
    while x <> 0 do
        begin
        workstr[start] := chr(ord('0') + x mod 10);
        start := start - 1;
        x := x div 10;
        end;
    if negative then
	begin
        workstr[start] := '-';
        start := start - 1;
        end;
    end;

len := strlen - start;
s := '';
for i := 1 to width - len do
    s := s + ' ';
for i := 1 to len do
    s := s + workstr[start + i];
end;
