#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#include <errno.h>
#include <sys/param.h>
#include <sys/file.h>

#include "contest.h"

#define LINE_MAX 81

	char *
check_env_var(env_var, def)
        char *env_var;
	char *def;
{
	char *val;

	val = getenv(env_var);
	return val != 0 ? val : def;
}


	char *
get_teamdir(team)
	char *team;
{
	static char buffer[MAXPATHLEN];
	char *probset = check_env_var(PROBSET_ENV_NAME, CURRENT_COMP);
	char *probdir = PROBDIR;

	if (getuid() == geteuid()) {
		/*
		 * Only allow the PROBVAR override to be used in
		 * non-setuid programs.
		 */
		probdir = check_env_var(PROBVAR, PROBDIR);
	}
	(void) sprintf(buffer, "%s/%s/%s/%s", probdir, probset, SUBDIR, team); 
	return buffer;
}


	char *
get_contest_name()
{
	static char buffer[MAXPATHLEN];
	char *probset;
	char *probdir = check_env_var(PROBVAR, PROBDIR);
	char link_name[MAXPATHLEN];
	int len;
	
	if ((probset = getenv(PROBSET_ENV_NAME)) != 0) {
		strcpy(buffer, probset);
	} else {
		(void) sprintf(link_name, "%s/%s", probdir, CURRENT_COMP);
		len = readlink(link_name, buffer, MAXPATHLEN);
		if (len <= 0 || len == MAXPATHLEN) {
			(void) fprintf(stderr,
				       "Error getting competition name\n");
			buffer[0] = '\0';     /* return empty name on error */
		} else {
			buffer[len] = '\0';
		}
	}
	return buffer;
}	


        int
read_results(team, head)
        char *team;
        struct result_list **head;
{
	char path[MAXPATHLEN];
	FILE *results;
	struct result_list **curr_res;
	struct result_list *new_elem;
	char buffer[LINE_MAX];

	*head = 0;  curr_res = head;
        (void) strcpy(path, get_teamdir(team));
	if (access(path, W_OK) == -1) {
		return 0;
	}

	(void) strcat(path, "/");
	(void) strcat(path, RESULTS_FILE);
	if ((results = fopen(path, "r")) == 0) {
		/*
		 * No results recorded yet - *head is already 0 so we
		 * can just return now
		 */
		return 1;
	}

	while (fgets(buffer, LINE_MAX, results)) {
		char *cp1, *cp2;
		unsigned len;

		if (buffer[strlen(buffer) - 1] != '\n') {
			return 0;
		}

		for (cp1 = buffer ; *cp1 && isspace(*cp1) ; cp1++)
		  ;
		for (cp2 = buffer ; *cp2 && !isspace(*cp2) ; cp2++)
		  ;
		if (*cp1 == 0 || *cp2 == 0) {
			return 0;
		}

		len = cp2 - cp1 + 1;
		new_elem = (struct result_list *) emalloc(sizeof(*new_elem));
		new_elem->program = emalloc(len);
		(void) strncpy(new_elem->program, cp1, len-1);
		new_elem->program[len-1] = 0;

		if (sscanf(cp2, " %d", &new_elem->result) != 1) {
			return 0;
		}
		new_elem->next = 0;
		*curr_res = new_elem;
		curr_res = &new_elem->next;
	}
	return 1;
}


        int
write_results(team, results)
        char *team;
        struct result_list *results;
{
	char path[MAXPATHLEN];
	FILE *res_file;

	(void) sprintf(path, "%s/%s", get_teamdir(team), RESULTS_FILE);
	if ((res_file = fopen(path, "w")) == 0) {
		return 0;
	}
	while (results) {
		(void) fprintf(res_file, "%s %d\n", results->program,
			       results->result);
		results = results->next;
	}
	(void) fclose(res_file);
	return 1;
}


        char
extract_problem(filename)
        char *filename;
{
	assert (strlen(filename) > strlen(PREFIX) + 1);

	return filename[strlen(PREFIX)];
}


        int
extract_version(filename)
        char *filename;
{
	assert (strlen(filename) > strlen(PREFIX) + 2);

	return atoi(filename + strlen(PREFIX) + 1);
}


char *messages[MAX_RES - MIN_RES + 1] = {
	"Correct!",
	"Syntax Errors",
	"See Clarifications",
	"Run-Time Error",
	"Over Time Limit",
	"Wrong Answer",
	"Failed Test Case",
	"Inaccurate Answer",
	"Too Little/Too Much Output",
	"Bad Output Format",
};

        char *
error_message(errnum)
        int errnum;
{
	if (errnum < MIN_RES || errnum > MAX_RES) {
		return "EEEEKKKK!!!!! INVALID RESULT CODE";
	}
	return messages[errnum - MIN_RES];
}

        char *
emalloc(size)
        unsigned size;
{
	char *ret_val;
	char *malloc();
	
	if ((ret_val = malloc(size)) == 0) {
		(void) fprintf(stderr, "Malloc failure\n");
		exit(1);
	}
	return ret_val;
}


        int
prob_search(path)
        char *path;
{
	char *lp;
	char *cp;
	int fd;
	char filename[MAXPATHLEN];
        static char langs[] = LANG_LETTERS;

	(void) strcpy(filename, path);
	(void) strcat(filename, ".");
	cp = &filename[strlen(filename)];

        (void) strcpy(langs, LANG_LETTERS);
        lp = strtok(langs, ":");
	do {
		(void) strcpy(cp, lp);
		if ((fd = open(filename, O_RDONLY)) == -1) {
			if (errno != ENOENT) {
				return -2;
			}
		} else {
			strcpy(path, filename);
			return fd;
		}
	} while (lp = strtok(NULL, ":"));
	return -1;
}


