PROGRAM Recycling;

#include "str.h"

CONST probname = 'PROBLEM';
      probnumber = 'G';

VAR   wastech : set of char;
      binch : set of char;

TYPE waste = (Plastic, Glass, Aluminium, Steel, Newspaper);
     bins  = (red, orange, yellow, green, blue);

VAR  debugcounter: integer;
     alloc : array[waste, bins] of integer;
     w : waste;
     b : bins;
     w_name : array[char] of waste;
     b_name : array[char] of bins;
     city : array[1..100, waste] of bins;
     cityno : integer;

FUNCTION ReadData : Boolean;   forward;
PROCEDURE Solveproblem;        forward;

PROCEDURE MainProg;
begin  {Main}

wastech := ['P', 'G', 'A', 'S', 'N'];
binch := ['r', 'o', 'y', 'g', 'b'];

w_name['P'] := Plastic; w_name['G'] := Glass;      w_name['A'] := Aluminium;
w_name['S'] := Steel;   w_name['N'] := Newspaper;
b_name['r'] := red;     b_name['o'] := orange;     b_name['y'] := yellow;
b_name['g'] := green;   b_name['b'] := blue;

while ReadData do
  SolveProblem;

end; {of main procedure}

PROCEDURE Error(s : string);
begin writeln; writeln(s); HALT end;

FUNCTION ReadData : Boolean;
VAR s: string;
    more : Boolean;
    w_used : array[waste] of Boolean;
    b_used : array[bins] of Boolean;
    i : integer;
    ch : char;

begin
for w := Plastic to Newspaper do
  for b := red to blue do alloc[w, b] := 0;
cityno := 0;

readln(s);
more := s <> '#';
if more then
  repeat
    s := s + ','; inc(cityno);
    if length(s) mod 4 <> 0
      then Error('Illegal length string ' + s);
    for w := Plastic to Newspaper do w_used[w] := false;
    for b := red to blue do b_used[b] := false;
    i := 0;
    repeat
      inc(i); ch := s[i];
      if not (ch in binch) then Error('Illegal colour ' + ch);
      b := b_name[ch];
      inc(i); ch := s[i];
      if ch <> '/' then Error('Illegal separator ' + ch);
      inc(i); ch := s[i];
      if not (ch in wastech) then Error('Illegal waste ' + ch);
      w := w_name[ch];
      inc(i); ch := s[i];
      if ch <> ',' then Error('Illegal comma ' + ch);
      if w_used[w] then Error('Double waste on this line'); w_used[w] := true;
      if b_used[b] then Error('Double colour on this line'); b_used[b] := true;
      city[cityno, w] := b;
      until i >= length(s);
    Alloc[w,b] := Alloc[w,b] + 1;
    readln(s);
    until s[1] = 'e';

ReadData := more;
end;  {Read Data}

PROCEDURE SolveProblem;
VAR i,j, sum, max, n : integer;

begin
max := 0; n := 0;
for i := 1 to cityno do begin
  sum := 0;
  for j := 1 to cityno do
    for w := Plastic to Newspaper do
      sum := sum + ord(city[i,w] = city[j,w]);
  if sum > max
    then begin max := sum; n := i end;
  end;

writeln(n:1);
end;

begin mainprog end.
