{ @(#)problemc.p 1.2 92/05/13 }

PROGRAM MouseClicks;
VAR debugcounter: integer;
CONST max_regions = 25;
      max_icons = 50;
      max = 499; {size of desktop}
TYPE  r_index = 0..max_regions;
      i_index = 0..max_icons;
      d_index = 0..max;
      point = record x,y: d_index end;
      region = record ltr:char; topleft, botright:point end;
      linetype = (rgn, icn, mck, eof);

VAR   all_the_regions: array[r_index] of region;
      all_the_icons: array[i_index] of point;
      r_count: r_index;
      i_count: i_index;
      click: point;

PROCEDURE Find(click: point);
VAR  i: i_index;
     r: r_index;
     xc,yc: d_index;
     hitlist: array[i_index] of i_index;
     hitcount: i_index;
     min,d,d1,d2 : integer;

  FUNCTION InRegion(r: r_index; x,y: d_index): Boolean;
  begin
  with all_the_regions[r] do
    InRegion := (x >= topleft.x) AND (x <= botright.x)
        AND (y >= topleft.y) AND (y <= botright.y);
  end;

begin
xc := click.x; yc := click.y;
{Find region first - if one exists}
r := r_count;
while not InRegion(r, xc,yc) do r := r - 1;
if r <> 0
  then writeln(all_the_regions[r].ltr)
  else begin
    min := maxint;
    for i := 1 to i_count do
      with all_the_icons[i] do begin
        r := r_count; while not InRegion(r, xc,yc) do r := r - 1;
        if r = 0
          then begin
            d1 := (x-xc); d2 := (y-yc);
            d := d1*d1 + d2*d2;
            if d < min
              then begin min := d; hitcount := 0 end;
            if d = min
              then begin hitcount := hitcount + 1; hitlist[hitcount] := i end;
            end;
        end;  {for i := 1 to i_count}
    for i := 1 to hitcount do write(hitlist[i]:3); writeln;
    end;  {looking for nearest icons}
end;

FUNCTION ReadLine: linetype;
VAR ch: char;

begin
read(ch);
case ch of
  'I': begin ReadLine := icn;
       i_count := i_count + 1;
       with all_the_icons[i_count] do readln(x, y);
       end;
  'R': begin ReadLine := rgn;
       r_count := r_count + 1;
       with all_the_regions[r_count] do begin
         ltr := chr(r_count-1 + ord('A'));
         with topleft do read(x, y);
         with botright do readln(x, y);
         end;
       end;
  'M': begin ReadLine := mck;
       with click do readln(x,y);
       Find(click);
       end;
  '#': ReadLine := eof;
  otherwise begin
    writeln('Error in input - invalid char = ', ch); readln end
  end;  {case}
end;

begin  {Main}

i_count := 0; r_count := 0;
with all_the_regions[0] do begin
  ltr := '?';
  with topleft do begin x := 0; y := 0 end;
  with botright do begin x := max; y := max end;
  end;
while ReadLine <> eof do;
end. {of program}
