#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <assert.h>

#define MAX_ITEMS 100
#define NAME_LEN 10
#define DUMMY_VAL -9999

struct items {
	char name[NAME_LEN+1];
	char depends_on[NAME_LEN+1];
	int dep_index;
	int  offset;
	int val;                  /* DUMMY_VAL if not resolved yet */
};


struct items array[MAX_ITEMS];
int num_items = 0;
main()
{
	read_items();
	add_undefined_items();
	sort_items();
	number_items();
	price_items();
	print_items();
}


read_items()
{
	int next_char;
	char temp[NAME_LEN+1];
	int line_no = 0;

	for (; (next_char = getchar()) != EOF && next_char != '#' ;
	     num_items++) {
		ungetc(next_char, stdin);
		
		line_no++;
		if (scanf("%s %*s %s", array[num_items].name, temp) != 2) {
			fprintf(stderr, "Error 1 reading table on line %d\n",
				line_no);
			exit(1);
		}

		if (isdigit(temp[0])) {
			array[num_items].val = atoi(temp);
			continue;
		}
	       
		array[num_items].offset = 0;
		array[num_items].val = DUMMY_VAL;
		strcpy(array[num_items].depends_on, temp);

		while ((next_char = getchar()) == ' ')
		  ;

		if (next_char == '+' || next_char == '-') {
			if (scanf("%d", &array[num_items].offset) != 1) {
				fprintf(stderr,
					"Error 2 reading table on line %d\n",
					line_no);
				exit(1);
			}
			if (next_char == '-') {
				array[num_items].offset *= -1;
			}
		}
	}
}


add_undefined_items()
{
	int i;

	for (i = 0 ; i < num_items ; i++) {
		if (array[i].val == DUMMY_VAL &&
		    array[i].depends_on[0] != 0 &&
		    find_item(array[i].depends_on) == -1) {
			strcpy(array[num_items].name, array[i].depends_on);
			array[num_items].val = DUMMY_VAL;
			array[num_items].dep_index = DUMMY_VAL;
			array[num_items].depends_on[0] = 0;
			num_items++;
		}
	}
}


sort_items()
{
	int i,j;
	struct items temp;

	for (i = num_items-1 ; i > 0 ; i--) {
		for (j = 0 ; j < i ; j++) {
			if (strcmp(array[j].name, array[j+1].name) > 0) {
				temp = array[j];
				array[j] = array[j+1];
				array[j+1] = temp;
			}
		}
	}
}


number_items()
{
	int i, j;

	for (i = 0 ; i < num_items ; i++) {
		if (array[i].val == DUMMY_VAL &&
		    array[i].dep_index != DUMMY_VAL) {
			array[i].dep_index = find_item(array[i].depends_on);
		}
	}
}


price_items()
{
	int changes, i;

	do {
		changes = 0;

		for (i = 0 ; i < num_items ; i++) {
			if (array[i].val == DUMMY_VAL &&
			    array[i].dep_index != DUMMY_VAL &&
			    array[array[i].dep_index].val != DUMMY_VAL) {
				array[i].val = array[array[i].dep_index].val +
				  array[i].offset;
				changes++;
			}
		}
	} while (changes > 0);
}


print_items()
{
	int i;

	for (i = 0 ; i < num_items ; i++) {
		printf("%-12s$", array[i].name);
		if (array[i].val < 0) {
			printf("blank\n");
		} else {
			printf("%2d.%2.2d\n", array[i].val / 100,
			       array[i].val % 100);
		}
	}
}


find_item(name)
        char *name;
{
	int i;

	for (i = 0 ; i < num_items ; i++) {
		if (strcmp(name, array[i].name) == 0) {
			return i;
		}
	}
	return -1;
}
