
/*
 * $Id: library.c,v 1.5 1993/06/16 16:41:30 wade Exp $
 *
 * $Log: library.c,v $
 * Revision 1.5  1993/06/16  16:41:30  wade
 * never found weird AIX mpi problem; changed index file instead
 *
 * Revision 1.4  1993/01/01  18:48:08  wade
 * corrected contextual help message for class selection mode
 *
 * Revision 1.3  1992/12/15  21:06:05  wade
 * using text instead of bitmaps for contextual help
 *
 * Revision 1.2  1992/12/05  17:15:51  larose
 * added rcs logging.
 *
 *
 */

#include "xnl.h"

int num_lines;

void libSelect();


libraryCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
        Mode_desired = MODE_LIBRARY;
}

Popup_library(w)
Widget w;
{
    LibOrClass = Mode = MODE_LIBRARY;

    grey_the_button(libraryButton, False);

    XtManageChild(libraryPop);

    set_status(LIB_HEADER, GREEN);
	return 1;
}


restart_library()
{
    register int i;

	for (i=0; FileList[i]; i++)
		XtFree(FileList[i]);
	for (i=0; List[i]; i++)
		XtFree(List[i]);
	for (i=0; topdirList[i]; i++)
		XtFree(topdirList[i]);

    make_library(toplevel);
}

make_library(w)
Widget w;
{
    Arg args[20];
    register int n;
    Boolean fileAvailable;
    char label[MAXLINE];


    if (libraryPop) { /* this is a restart */
        XtDestroyWidget(libraryPop);
    } else
		con_help[MODE_LIBRARY] = con_help[MODE_CLASSSELECT] = "\n\
Library mode displays a table of the\n\
top level libraries.\n\
\n\
Click on one with the left mouse button\n\
to select.\n";


    fileAvailable = (libLoadList() > 0);

    n = 0;
    XtSetArg(args[n], XtNallowHoriz, True);        n++;
    XtSetArg(args[n], XtNallowVert, True);        n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    libraryPop = XtCreateWidget("libViewport", 
            viewportWidgetClass, topPane, args, n);

    if (fileAvailable) {
        n = 0;
        XtSetArg(args[n], XtNborderWidth, 0); n++;
        XtSetArg(args[n], XtNlist, topdirList); n++;
        XtSetArg(args[n], XtNdefaultColumns, 5); n++;
		XtSetArg(args[n], XtNforceColumns, True); n++;
        libraryList = XtCreateManagedWidget("libList", 
                listWidgetClass, libraryPop, args, n);
        XtAddCallback(libraryList, XtNcallback,     
            libSelect, (XtPointer)NULL);
    } else {
        n = 0;
        XtSetArg(args[n], XtNborderWidth, 0); n++;
        sprintf(label, "couldn't find the library index %s/%s\n    press 'Set Up' to download index files", XNL_PATH, LIB_FILE);
        XtSetArg(args[n], XtNlabel, label); n++;
        XtCreateManagedWidget("libList",
                labelWidgetClass, libraryPop, args, n);
    }
    
    return 1;
}

Popdown_library(w)
Widget w;
{
    XtUnmanageChild(libraryPop);

    grey_the_button(libraryButton, True);

    return 1;
}


libLoadList()
{
    FILE *fp;
    char filename[MAXLINE];
    char line[MAXLINE];
    char name[MAXLINE], file[MAXLINE];
    int num_topdirs;
    unsigned long age;
    register int i;
    int retval = 0;

	String tmp_ptr;
	int hits, tmp_int;
    
    num_topdirs = 
    num_lines = 0;
    
    for (i=0; i < Many_servers; i++) {
    
#ifdef DEBUG
      printf(" library index  %s\n", server_list[i]);
#endif

      sprintf(filename, "%s/%s/%s", XNL_PATH, server_list[i], LIB_FILE);
    
      if (!confirmFile(filename, (PUBDATA) ? 1 : 0, False, False)) {
        sprintf(line, "couldn't contact server %s", server_list[i]);
        report(toplevel, line);
      }
    

      /* first open the file and discover num_lines */
      fp = fopen(filename, "r");
      if (fp) {
        char tmp[255];
        register int n;
        
        /* eat the first 2 lines, the age and the tag */
        fgets(line, MAXLINE, fp);
        fgets(line, MAXLINE, fp);
        sscanf(line, "%d", &age);
        strcpy(tmp, age2s(what_time() - age) );
#ifdef DEBUG
        printf("index is %s old\n", tmp);
#endif

        while (fgets(line, MAXLINE, fp)) {
            if (-1 == file_is_dir(line))
                continue;   /* ignore this line */

            line[ strlen(line) -1] = '\0';

            /* strip leading 'lib' and whitespace */
            n = 4; while (line[n] && white_char(line[n]))   n++;

            strcpy(name, line+n);
            sprintf(file, "%s/%s/index", server_list[i], name);
            
            List[num_lines] = XtNewString(name);
            FileList[num_lines] = XtNewString(file);

            num_lines++;

            if (is_top_dir(name) && 
               /* and not already in the list */
               (!name_in_list(name, num_topdirs)) ) {
                topdirList[num_topdirs] = XtNewString(name);
                topdirServerList[num_topdirs] = i;
                num_topdirs++;
            }
        }

        fclose(fp);
	retval++;
      }
    }
    
    /* NULL term */
    FileList[num_lines] =
    List[num_lines] = NULL;
    topdirList[num_topdirs] = NULL;
    topdirServerList[num_topdirs] = -1;

    /* sort the list by the alphabet */
	hits=1; /* to get things going.. */
	while (hits) {
		hits=0;
		for (i=0; List[i]; i++) {
			if ((List[i+1]) && (strcmp(List[i], List[i+1]) > 0)) {
				/* make the swap */
				hits=1;
				tmp_ptr = List[i]; List[i] = List[i+1]; List[i+1] = tmp_ptr;
				tmp_ptr = FileList[i]; FileList[i] = FileList[i+1]; 
					FileList[i+1] = tmp_ptr;
			}
		}
	}
    
	hits=1; /* to get things going.. */
	while (hits) {
		hits=0;
		for (i=0; topdirList[i]; i++) {
			if ((topdirList[i+1]) && 
						(strcmp(topdirList[i], topdirList[i+1]) > 0)) {
				/* make the swap */
				hits=1;
				tmp_ptr = topdirList[i]; topdirList[i] = topdirList[i+1]; 
					topdirList[i+1] = tmp_ptr;
				tmp_int = topdirServerList[i]; 
					topdirServerList[i] = topdirServerList[i+1]; 
					topdirServerList[i+1] = tmp_int;
			}
		}
	}

    return retval;
}

name_in_list(name, num_topdirs)
char *name;
int num_topdirs;
{
    register int i;
    
    for (i=0; i < num_topdirs; i++)
      if (strcmp(name, topdirList[i]) == 0)
        return 1;
    return 0;
}

void
libSelect(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
	char s[1024];
    XawListReturnStruct *item = (XawListReturnStruct*)call_data;

	strcpy(s, item->string);

    Popdown_library(libraryButton);

    Mode_last = MODE_LIBRARY;

    Popup_libSelect(s);

}


/* if s contains a / then it isn't a top level dir */
is_top_dir(s)
char *s;
{
    register int i;
    
    /* never display xnlindex */
    if (strcmp("xnlindex", s) == 0)
      return 0;
      
    i = 0;
    while (s[i]) {
        if (s[i] == '/')
            return 0;
        i++;
    }

    return 1;
}



