/*
 * fasthelp module from Ken Bateman	20 Feb 92
 * for xnetlib 2.0
 * small changes 21 feb 92 - Reed Wade
 */

/*
 *
$Log: fasthelp.c,v $
 * Revision 1.2  1992/12/05  17:15:51  larose
 * added rcs logging.
 *
 *
 */

 
#include "xnl.h"
#define MAXFASTHELPS 200

static Widget fasthelplabel;
static Widget widgetname[MAXFASTHELPS];
static char * message[MAXFASTHELPS];
static int nextopenspot = 0;
static XtTranslations trans, tog_trans;
static char text_trans[] = "<EnterWindow>:	highlight() ShowFastHelp() \n\
	<LeaveWindow>:	reset() ClearFastHelp()";
static char tog_text_trans[] = "<EnterWindow>:	highlight() ShowFastHelp() \n\
	<LeaveWindow>:	unhighlight() ClearFastHelp()";


static fasthelpmessage( message )
String message;
{
  XtVaSetValues(fasthelplabel, XtNlabel, message, NULL );
}

/* ARGSUSED */
void ShowFastHelpaction( w, event, params, num_params )
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
  int i;
  for(i = 0; i < MAXFASTHELPS; i++) {
    if (widgetname[i] == w) {
      fasthelpmessage( message[i] );
      return;
    }
  }
  fasthelpmessage( STATUS_DEFAULT );
}


/* ARGSUSED */
void ClearFastHelpaction( w, event, params, num_params )
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
  fasthelpmessage (STATUS_DEFAULT);

}

   
init_fasthelp( thefasthelplabel, app_con )
Widget thefasthelplabel;
XtAppContext app_con;
{
  int i;
  static XtActionsRec fasthelpacts[] = {
    { "ShowFastHelp", ShowFastHelpaction },
    { "ClearFastHelp", ClearFastHelpaction } };
  XtAppAddActions( app_con, fasthelpacts, XtNumber(fasthelpacts));
  fasthelplabel = thefasthelplabel;
  for(i = 0; i < MAXFASTHELPS; i++) 
    message[i] = NULL;
    
  trans = XtParseTranslationTable(text_trans);
  tog_trans = XtParseTranslationTable(tog_text_trans);

}

setfasthelpmessage( w, msg )
Widget w;
String msg;
{
  int i;
 
  XtOverrideTranslations(w, trans);   
  
  for (i = 0; i < nextopenspot; i++)
    if (widgetname[i] == w) {
      message[i] = msg;
      return 1;
    }
  if (nextopenspot == MAXFASTHELPS)
    return 0;
  else {
    widgetname[nextopenspot] = w;
    message[nextopenspot] = msg;
    nextopenspot++;
    return 1;
  }
}
setfasthelpmessageTog( w, msg )
Widget w;
String msg;
{
  int i;

  XtOverrideTranslations(w, tog_trans);
 
  for (i = 0; i < nextopenspot; i++)
    if (widgetname[i] == w) {
      message[i] = msg;
      return 1;
    }
  if (nextopenspot == MAXFASTHELPS)
    return 0;
  else {
    widgetname[nextopenspot] = w;
    message[nextopenspot] = msg;
    nextopenspot++;
    return 1;
  }
}


/*
  The following translations must be installed for fasthelp to work
  correctly.

*Command.translations: #override\n\
	<EnterWindow>:	highlight() ShowFastHelp()\n\
	<LeaveWindow>:	reset() ClearFastHelp()
*/
