
/*
 *
$Log: GasGauge.c,v $
 * Revision 1.3  1993/05/24  16:36:21  wade
 * misc typecasting cleanup
 *
 * Revision 1.2  1992/12/05  17:15:51  larose
 * added rcs logging.
 *
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/XawInit.h>
#include "GasGaugeP.h"

/*LINTLIBRARY*/


#define DEGREES(a)  ((a) * 64)	/* convert degrees to Xlib angle measure  */

/* the E and F bitmaps */
#define e_width 18
#define e_height 32
static char e_bits[] = {
 0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0xfc,0xff,0xfc,
 0xfc,0xff,0xfc,0xfc,0xff,0xfc,0xfc,0xff,0xfc,0x3c,0x00,0xfc,0x3c,0x00,0xfc,
 0x3c,0x00,0xfc,0x3c,0x00,0xfc,0x3c,0x00,0xfc,0x3c,0x00,0xfc,0xfc,0x0f,0xfc,
 0xfc,0x0f,0xfc,0xfc,0x0f,0xfc,0xfc,0x0f,0xfc,0x3c,0x00,0xfc,0x3c,0x00,0xfc,
 0x3c,0x00,0xfc,0x3c,0x00,0xfc,0x3c,0x00,0xfc,0x3c,0x00,0xfc,0xfc,0xff,0xfc,
 0xfc,0xff,0xfc,0xfc,0xff,0xfc,0xfc,0xff,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,
 0x00,0x00,0xfc,0x00,0x00,0xfc};
#define f_width 18
#define f_height 32
static char f_bits[] = {
 0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,0xfc,0xff,0xfc,
 0xfc,0xff,0xfc,0xfc,0xff,0xfc,0xfc,0xff,0xfc,0x3c,0x00,0xfc,0x3c,0x00,0xfc,
 0x3c,0x00,0xfc,0x3c,0x00,0xfc,0x3c,0x00,0xfc,0x3c,0x00,0xfc,0xfc,0x0f,0xfc,
 0xfc,0x0f,0xfc,0xfc,0x0f,0xfc,0xfc,0x0f,0xfc,0x3c,0x00,0xfc,0x3c,0x00,0xfc,
 0x3c,0x00,0xfc,0x3c,0x00,0xfc,0x3c,0x00,0xfc,0x3c,0x00,0xfc,0x3c,0x00,0xfc,
 0x3c,0x00,0xfc,0x3c,0x00,0xfc,0x3c,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,0xfc,
 0x00,0x00,0xfc,0x00,0x00,0xfc};

Pixmap e_pixmap = (Pixmap)NULL, f_pixmap = (Pixmap)NULL;

static Dimension wideDim = 300;
static Dimension highDim = 50;


/* see gas_resources kludge in main before adding/removing resources */

#define offset(field) XtOffset(GasGaugeWidget, field)
XtResource gas_resources[] = {
	/* 0 */
    { XtNwidth, XtCWidth, XtRDimension, sizeof(Dimension),
        offset(core.width), XtRDimension, (caddr_t)&wideDim },

	/* 1 */
    { XtNheight, XtCHeight, XtRDimension, sizeof(Dimension),
        offset(core.height), XtRDimension, (caddr_t)&highDim },
        
	/* 2 */
    {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
        offset(gasGauge.fg_pixel), XtRString, XtDefaultForeground},

	/* 3 */
    {XtNdial, XtCBackground, XtRPixel, sizeof(Pixel),
        offset(gasGauge.dial_pixel), XtRString, "DarkViolet"},
        /*offset(gasGauge.dial_pixel), XtRString, XtDefaultForeground},*/

	/* 4 */
    {XtNneedle, XtCForeground, XtRPixel, sizeof(Pixel),
        offset(gasGauge.needle_pixel), XtRString, "yellow"},
        /*offset(gasGauge.needle_pixel), XtRString, XtDefaultBackground},*/

	/* 5 */
    {XtNef, XtCBackground, XtRPixel, sizeof(Pixel),
        offset(gasGauge.ef_pixel), XtRString, "red"},
        /*offset(gasGauge.ef_pixel), XtRString, XtDefaultForeground},*/

	/* 6 */
    {XtNgasValue, XtCGasValue, XtRInt,  sizeof(int),
	offset(gasGauge.value), XtRImmediate, (caddr_t)0},

	/* 7 */
    {XtNfont,  XtCFont, XtRFontStruct, sizeof(XFontStruct *),
	offset(gasGauge.font),XtRString, "XtDefaultFont"},

	/* 8 */
    {XtNmaxValue, XtCMaxValue, XtRInt,  sizeof(int),
	offset(gasGauge.max_value), XtRImmediate, (caddr_t)100},
};

static void Initialize();
static void Resize();
static void Redisplay();
static Boolean SetValues();
static void ClassInitialize();
static void Destroy();

GasGaugeClassRec gasGaugeClassRec = {
  {
/* core_class fields */	
#define superclass		(&simpleClassRec)
    /* superclass	  	*/	(WidgetClass) superclass,
    /* class_name	  	*/	"GasGauge",
    /* widget_size	  	*/	sizeof(GasGaugeRec),
    /* class_initialize   	*/	ClassInitialize,
    /* class_part_initialize	*/	NULL,
    /* class_inited       	*/	FALSE,
    /* initialize	  	*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize		  	*/	XtInheritRealize,
    /* actions		  	*/	NULL,
    /* num_actions	  	*/	0,
    /* resources	  	*/	gas_resources,
    /* num_resources	  	*/	XtNumber(gas_resources),
    /* xrm_class	  	*/	NULLQUARK,
    /* compress_motion	  	*/	TRUE,
    /* compress_exposure  	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest	  	*/	FALSE,
    /* destroy		  	*/	Destroy,
    /* resize		  	*/	Resize,
    /* expose		  	*/	Redisplay,
    /* set_values	  	*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus	 	*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private   	*/	NULL,
    /* tm_table		   	*/	NULL,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
/* Simple class fields initialization */
  {
    /* change_sensitive		*/	XtInheritChangeSensitive
  }
};
WidgetClass gasGaugeWidgetClass = (WidgetClass)&gasGaugeClassRec;

static void ClassInitialize()
{
    extern void XmuCvtStringToJustify();
    extern void XmuCvtStringToBitmap();
    static XtConvertArgRec screenConvertArg[] = {
        {XtWidgetBaseOffset, (caddr_t) XtOffset(Widget, core.screen),
	     sizeof(Screen *)}
    };
    XawInitializeWidgetSet();
} /* ClassInitialize */

static void LooseGCs(w)
    GasGaugeWidget w;
{
        XtReleaseGC((Widget)w, w->gasGauge.dial_GC);
        XtReleaseGC((Widget)w, w->gasGauge.ef_GC);
        XtReleaseGC((Widget)w, w->gasGauge.needle_GC);
        XtReleaseGC((Widget)w, w->gasGauge.fg_GC);

}

static void GetGCs(w)
    GasGaugeWidget w;
{
    XGCValues	values;

#define MAKEGC(A, B, C) \
    values.foreground	= w->gasGauge.A; \
    values.background	= w->core.background_pixel; \
    values.line_width   = C; \
    values.font		= w->gasGauge.font->fid; \
    w->gasGauge.B = XtGetGC( (Widget)w, \
	(unsigned) GCForeground | GCBackground | GCFont | GCLineWidth, &values);

    MAKEGC(fg_pixel, fg_GC, 1)
    MAKEGC(dial_pixel, dial_GC, 30)
    MAKEGC(ef_pixel, ef_GC, 4)
    MAKEGC(needle_pixel, needle_GC, 15)
}


/* ARGSUSED */
static void Initialize(request, new)
 Widget request, new;
{
    GasGaugeWidget w = (GasGaugeWidget) new;

    w->gasGauge.last_value = 0;

    GetGCs(w);

} /* Initialize */

make_pixmaps(w)
Widget w;
{
    e_pixmap = XCreateBitmapFromData (XtDisplay(w), XtWindow(w),
                e_bits, e_width, e_height);
    f_pixmap = XCreateBitmapFromData (XtDisplay(w), XtWindow(w),
                f_bits, f_width, f_height);
}

/* ARGSUSED */
static void Redisplay(w, event, region)
    GasGaugeWidget w;
    XEvent *event;
    Region region;
{
 
   /* draw dial background */
   XDrawArc(XtDisplay(w), XtWindow(w), w->gasGauge.dial_GC,
     0,20, w->core.width, (unsigned int)(w->core.height * 1.5), DEGREES(40), DEGREES(100) );
   /* draw tick marks and outline */
   /* draw E and F */
   if (e_pixmap == (Pixmap)NULL)
     make_pixmaps(w);
  
   XCopyPlane(XtDisplay(w), e_pixmap, XtWindow(w), w->gasGauge.ef_GC,
     0,0, e_width, e_height, 20, (w->core.height/2) - (e_height/2), 1);
   XCopyPlane(XtDisplay(w), f_pixmap, XtWindow(w), w->gasGauge.ef_GC,
     0,0, f_width, f_height, w->core.width -20 -f_width, (w->core.height/2) - (f_height/2), 1);
     
   /* draw indicator */
   w->gasGauge.last_value = 0; /* force a complete needle */
   draw_needle(w);
}

draw_needle(w)
GasGaugeWidget w;
{
   register int degrees_to_show;   

   degrees_to_show = ( (w->gasGauge.value * 100) / (w->gasGauge.max_value) );
   
   if (degrees_to_show > 100)
     degrees_to_show = 100;
     
   if (w->gasGauge.last_value == degrees_to_show) /* skip it */
     return;
     
   if (w->gasGauge.last_value > degrees_to_show) { /* need to erase some */
     XDrawArc(XtDisplay(w), XtWindow(w), w->gasGauge.dial_GC,
         0,20, w->core.width, (unsigned int)(w->core.height * 1.5), DEGREES(40),
         DEGREES(100 - degrees_to_show) );     
   } else {   
     if (degrees_to_show)
       XDrawArc(XtDisplay(w), XtWindow(w), w->gasGauge.needle_GC,
         0,20, w->core.width, (unsigned int)(w->core.height * 1.5), DEGREES(140 - degrees_to_show),
         DEGREES(degrees_to_show) );
   }
   
   w->gasGauge.last_value = degrees_to_show;

}


static void Resize(w)
    Widget w;
{
/*
    GasGaugeWidget gw = (GasGaugeWidget)w;
    Position dx, dy;
printf("Resize()\n");
*/
}


static Boolean SetValues(current, request, new, args, num_args)
    Widget current, request, new;
    ArgList args;
    Cardinal *num_args;
{
    GasGaugeWidget curgw = (GasGaugeWidget) current;
    GasGaugeWidget newgw = (GasGaugeWidget) new;
    Boolean was_resized = False, redisplay = False;

    if (curgw->gasGauge.value != newgw->gasGauge.value) 
	draw_needle(newgw);
    else if (curgw->gasGauge.max_value != newgw->gasGauge.max_value) 
	draw_needle(newgw);


    return was_resized || redisplay ||
	   XtIsSensitive(current) != XtIsSensitive(new);
}

static void Destroy(w)
    Widget w;
{
    LooseGCs(w);
}


