.TH xnetlib 3.4 "28 jun 93"
.SH NAME
xnetlib - an X interface to netlib
.SH DESCRIPTION
.PP
.B Xnetlib 
is a new version of netlib recently developed at the
University of Tennessee and Oak Ridge National Laboratory.
Unlike netlib, which uses electronic mail to process requests
for software, xnetlib uses an X Window graphical
user interface and a socket-based connection between the user's
machine and the xnetlib server machine to process software
requests.  
.B Xnetlib 
is available to anyone who has access to the
TCP/IP Internet.
.PP
.SH OPERATION
.PP
When xnetlib starts up you are shown the Help screen. Pressing
the top row of buttons switches from mode to mode. Clicking on 'Library' 
displays the top level listing of items available via
xnetlib. You may think of this top level listing as a set of
UNIX style directories. Clicking on any of them displays the
contents with description. There may be further subdirectories, 
these are indicated by the folder icon. Files are indicated by
the dog-eared page icon. 
.PP
Clicking on a file adds it to the list
of files to download. Click 'Download' to actually get the files.
.PP
As you walk the netlib tree, examining the libraries you are interested
in, index files are obtained from the netlib server at
Oak Ridge National Laboratory, (netlib.ornl.gov).
Depending on your network connection this file grabbing
may be hardly noticeable or a terrible inconvenience.
.PP
Clicking on `Conferences' takes you into the Conferences
Database mode.  This mode is an experimental interface to
a more general database service based on the relational
database model.  The attribute names for the conferences
relation in the conferences database include title, start_date,
end_date, location, description, submit_date, and submitter.  
At the time when
a conference is submitted to the database, the title, location,
and description attributes are added to a full-text index.
Although it is currently incomplete, a geographical database
handles location name aliases (e.g., Great Britain and United
Kingdom) and hierarchical geographical relationships.
.PP
If you would like, you can have all the index files loaded while
you're out getting a bite instead of as you need them. 
Click 'Set Up', then 'Press to Check Each Index File'. This checks every
index file older than a certain age (see 
.B indexLifetime, 
in X RESOURCES) and
copies from the server any that are missing or changed.
These index files are stored in 
.B $HOME/xnlPath 
by default (see 
.B xnlPath,
in X RESOURCES).
.PP
If several people at the same site are using xnetlib, you may
want to maintain one shared collection of index files instead
of several separate collections. To do this set the
.B publicData
resource to True and have users set their xnlPath
resource to that directory. The effect of the 'publicData'
resource is that the xnlData directory and files in it are
world writable so that anyone may update the files. (You
might even set this as the default in the source. See the
fallback_resources in main.c.) 
.PP
.SH PLATFORMS
.PP
Most development of xnetlib is being done on an IBM RS/6000
running the X11R5 server and libraries. It has been tested  on
Sun, Decstation 5000, SGI 4D/25 running IRIX 3.3.3
with X11R4, Sequent, NeXT Dimension (w/CoExist), HP9000, and
Convex.
.PP
Please tell us about other environments it runs (or doesn't) under.
.PP
.SH FUTURE DIRECTIONS
.PP
General FTP support - with or without special index files on
the remote machine.
.PP
Fortran to C converter access via xnetlib.
.PP
Other such facilities.
.PP
More.
.PP
Please send us your comments. (xnetlib@cs.utk.edu)
.PP
.SH A ONE LINER
.PP
We have included a command line interface to netlib. It was a
last minute sort of thing and has not been well tested. To make
it, type:
.PP
make netlibget
.PP
Type 'netlibget' to see the usage
line. Netlibget uses the same routines to talk to netlib that
xnetlib does.
.PP
You may not want to use this for file retrieval now that the
main respository is open to anonymous ftp and rcp.
.PP
.SH X RESOURCES and COMMAND LINE OPTIONS
.PP
.B Xnetlib
understands the normal X Toolkit options (-display, -rv, etc) as well
as -help, and those listed here next to the X resources they affect.
.TP 3
.B indexLifetime (-life):
this is how many days you want to use an index file before checking that
it is current. No check will be made of the file
with the server if it is younger than this age. 
If set to zero, the server will be asked about the validity of each
index when it is referenced.
The default is 7 days.
.PP
It is worth going on a bit about some side-effects of
.B indexLifetime.
The value of
.B indexLifetime
determines how often xnetlib talks to the server. If it is set to
some very large number, there will be little unneeded communication.
The tradeoff there is that you might be looking at out of date index
files. If it is set to some very small number (like zero), you have
to wait while the server is consulted before each index is read.
.PP
A nice medium would probably be to run xnetlib with a high
.B indexLifetime
and every now and then start it up with the -life 0 option
and spin through all the index files in Set Up mode.
.PP
.TP 3
.B hostFile (-f,-file):
 Name of host file, The default is $HOME/.xnetlibHosts.
.PP
.TP 3
.B email (-email): 
Your prefered email address. Please set this value so you 
can be notified of updates to the software you get. If it isn't set, xnetlib
tries to guess but will be wrong about 1/3rd of the time.
.PP
.TP 3
.B entrySep (-es):
the separator displayed between entries in Who mode. 
The default is '-------'.
.PP
.TP 3
.B printCommand (-pc):
the format string for the print command.
The string must contain 
a %s which is replaced with the name of the file which is 
printed. The default is 'lpr %s'.
.PP
.TP 3
.B showWhoInfo (-showwho/-noshowwho):
whether to show instructions for adding your name 
to the NA-NET white pages database. The default is True.
.PP
.TP 3
.B xnlPath (-dp):
path to the local xnetlib database. The default is $HOME/xnlData.
.PP
.TP 3
.B publicData:
if True, save index files world writeable. The default is 
False.
.PP
.TP 3
.B xnlDownloadPath (-path):
path to directory where the files you select
are downloaded. The default is $HOME/xnlFiles
.PP
.TP 3
.B depCheck (-dc/-nodc):
if True then any files required by the items you 
explicitly request are downloaded also. The default is True.
.PP
.TP 3
.B showDownloadAnyway (-showdown/-noshowdown):
if True then the Download button is not greyed
out when there is nothing to download. The default is False.
.PP
.TP 3
.B confirmQuit (-cq/-nocq):
if True you are asked if you truly want to exit when
you press the Quit button. The default is False.
.PP
.TP 3
.B dontWarp (-dw):
sometimes xnetlib tries to help you out by placing the cursor
where it thinks you may want it. Set to True if you don't care for
this type of behavior. The default is False.
.PP
These colors affect the status message window background:
.PP
.TP 3
.B okColor: 
the happy color, normally green
.PP
.TP 3
.B badColor: 
the 'something's wrong' color, normally red
.PP
.TP 3
.B cautionColor: 
the 'something's almost wrong' color, normally yellow
.PP
Gas gauge resources.
.TP 3
.B dial:
the indicator background color. The default is DarkViolet.
.TP 3
.B needle:
the indicator color. The default is yellow.
.TP 3
.B ef:
the color of the E and F. The default is red.
.TP 3
.B gasGauge.background:
the color of the gauge background.
.PP
.SH BUGS
.PP
Please send bug reports to (xnetlib@cs.utk.edu). Include as much
information as possible, vendor and model, version of X, make logs, etc.
.PP
On Ultrix, you MUST either have MIT X windows (not DECWindows)
installed, OR have the "Unsupported X11 Components" software subset
loaded, in order to compile Xnetlib.  The include files supplied with
vanilla DECWindows are incompatible with those supplied by MIT and
required by Xnetlib.
.PP
.SH AUTHORS
.PP
This work is directed by Jack J. Dongarra, Univ. of Tennessee
and Oak Ridge National Laboratory, and Tom Rowan, Oak Ridge
National Laboratory, supported in part by the Applied
Mathematical Sciences subprogram of the Office of Energy
Research, U.S. Department of Energy, under contract
DE-AC05-84OR21400, and in part by the National Science
Foundation under contract NSF ASC-9103853.
.PP
Xnetlib has evolved over a period of time since 1991
and has had help from:  
David Bolt, University of Tennessee;
Jennifer Finger, Oak Ridge National Laboratory;
Stan Green,
Bob Manchek,
Keith Moore,
Andy Pearson, 
Bill Rosener, 
Jon Richardson, 
University of Tennessee;
Andrea Van Hull, Northwestern University and Oak Ridge National Laboratory.
.PP
Xnetlib 2.0-3.4 was written by Reed Wade, University of Tennessee (wade@cs.utk.edu)
.PP
The Performance Database module was written by Brian Larose,
University of Tennessee (larose@cs.utk.edu).
.PP
The Conferences Database module was written by Shirley Browne,
University of Tennessee (browne@cs.utk.edu).
.PP
Fasthelp code from:  Ken Bateman, Virginia Tech and Oak Ridge
National Laboratory
.PP
A very special thanks to victims of the prerelease code.
.PP
Convex fixes from:  salevin@drl.mobil.com
