/*************************************************************************/
/*                  VChat interactive IP-level chat system               */
/*-----------------------------------------------------------------------*/
/*  (c) '93/'94 by Andreas S. Wetzel (mickey@deadline.panic.bln.sub.org  */
/*                 All rights reserverd.                                 */ 
/*-----------------------------------------------------------------------*/
/* See the file COPYRIGHT in the top level directory of VChat for        */
/* copyright notices and further disclaimers.                            */ 
/*************************************************************************/

/************* Prototypes of functions **************/

/** vchat.c **/

void	main(int argc, char *argv[]);
void	init(void);
void	get_param(int argc, char *argv[]);
void	usage(char *fmt, ...);
void	handle_cmd(char *cmd);
void	quit(int stat, char *fmt, ...);
void	version_info(void);
void	chnick(char *nick);
void	chchan(char *chan);
void	help(void);
void	invite(char *user);
void	prv_msg(char *dat);
void	ulist(char *dat);
void	ring(char *dat);
void	who(char *dat);

/** screen.c **/

void	screen_init(void);
void	mv(int x, int y);
void	cls(void);
void	scr_mode(int sw);
void	scroll_reg(int start, int ende);
void	cprintf(int win, char *fmt, ...);
char	*vt(int pos, long attr);
void	winch(void);

/** inet.c **/

void	connect_server(void);
void	rcv_sv_msg(void);
void	snd_serv(int cmd, char *data, long siz);
void	flush_buf(void);

/** input.c **/

int	edline(char *line, int len);
void	chat_beep(void);

/** tty.c **/

void	tty_param(int action);
void	tty_mode(int sw);
