#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include "xutil.h"
#include "lutil.h"

#ifndef size_t
#define size_t unsigned short
#endif

char *xmalloc(size)
size_t size;
{
	char *tmp;

	tmp=malloc(size);
	if (!tmp)
	{
		log("Fatal: unable to allocate %d bytes\n",size);
		exit(-1);
	}
	return(tmp);
}

char *xstrcpy(src)
char *src;
{
	char	*tmp;

	if (!src) return(NULL);
	tmp=xmalloc(strlen(src)+1);
	strcpy(tmp,src);
	return(tmp);
}

char *xstrcat(src,add)
char *src,*add;
{
	char *tmp;
	size_t size=0;

	if (src) size=strlen(src);
	if (add) size+=strlen(add);
	if (size) tmp=xmalloc(size+1);
	else return(NULL);
	tmp[0]='\0';
	if (src) 
	{
		strcpy(tmp,src);
		free(src);
	}
	if (add) strcat(tmp,add);
	return(tmp);
}
