#include <stdio.h>
#include <varargs.h>
#include <unistd.h>
#include <errno.h>
#include <time.h>
#include <sys/types.h>

FILE *logfile=NULL;
int verbose=0;
char *logname="/tmp/tmplog";

char *strerror(errno)
int errno;
{
	extern char *sys_errlist[];
	extern int sys_nerr;
	if ((errno >= 0) && (errno <= sys_nerr))
		return(sys_errlist[errno]);
	else
		return("unknown error");
}

char *date(t)
time_t t;
{
	struct tm ptm;
	time_t now;
	static char buf[20];

	if (t) now=t; 
	else time(&now);
	ptm=*localtime(&now);
	sprintf(buf,"%02d/%02d/%02d %02d:%02d:%02d",
		ptm.tm_year%100,ptm.tm_mon+1,ptm.tm_mday,
		ptm.tm_hour,ptm.tm_min,ptm.tm_sec);
	return(buf);
}

void log(va_alist)
va_dcl
{
	va_list	args;
	char	*fmt;

	va_start(args);
	fmt=va_arg(args, char*);

	if (verbose)
	{
		vfprintf(stderr,*fmt == '$' ? fmt+1 : fmt,args);
		if (*fmt == '$') 
			fprintf(stderr,"\n\terrno=%d : %s\n",
				errno,strerror(errno));
		else
			fprintf(stderr,"\n");
	}

	if (!logfile)
	if ((logfile=fopen(logname,"a")) == NULL)
	{
		perror("Cannot open log file");
		return;
	}
	fprintf(logfile,"%s %05d ",date(0L),getpid());
	vfprintf(logfile,*fmt == '$' ? fmt+1 : fmt,args);
	if (*fmt == '$') 
		fprintf(logfile,"\n\terrno=%d : %s\n",
			errno,strerror(errno));
	else
		fprintf(logfile,"\n");
	fflush(logfile);

	va_end(args);
	return;
}

void debug(va_alist)
va_dcl
{
	va_list	args;
	int	level;
	char	*fmt;

	va_start(args);
	level=va_arg(args, int);
	fmt=va_arg(args, char*);

	if (level <= verbose)
	{
		vfprintf(stderr,*fmt == '$' ? fmt+1 : fmt,args);
		if (*fmt == '$') 
			fprintf(stderr,"\n\terrno=%d : %s\n",
				errno,strerror(errno));
		else
			fprintf(stderr,"\n");
	}
	va_end(args);
	return;
}
