/* This module implements BinkleyTerm packet naming conventions */

#include <stdio.h>
#include <string.h>
#include "lutil.h"
#include "xutil.h"
#include "ftn.h"
#include "config.h"

#define MAXLEN 256
#define ptyp "out"

char *pktname(addr)
faddr *addr;
{
	static char buf[MAXLEN];
	char zpref[8];

	if ((addr->zone == 0) || (addr->zone == whoami->addr->zone))
		zpref[0]='\0';
	else sprintf(zpref,".%03d",addr->zone);

	if (addr->point)
		sprintf(buf,"%s%s/%04x%04x.pnt/%08x.%s",
			outbound,zpref,addr->net,addr->node,addr->point,ptyp);
	else
		sprintf(buf,"%s%s/%04x%04x.%s",
			outbound,zpref,addr->net,addr->node,ptyp);
	debug(3,"packet name is \"%s\"",buf);
	return buf;
}
