#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include "lutil.h"
#include "config.h"
#include "Version"
#include "ftn.h"
#include "getheader.h"

extern char *getenv(char *);
extern int getopt();
extern char *optarg;
extern int optind;

extern int atoi(char *);
extern int getmessage(FILE *,FILE*,faddr *,faddr *);

extern int verbose;
extern char *logname;
extern char *configname;

extern int num_echo,num_mail;

int usetmp=1; /* to tell bgets that we do not use batch mode */

void usage(name)
char *name;
{
	fprintf(stderr,"%s Version %s of %s, Copyright (c) %s\n",
		name,version,DATE,copyright);
	fprintf(stderr,"This is free software. You can do what you wish \
with it if you preserve\nthis copyright notice.\n\n");
	fprintf(stderr,"usage: %s -h -x<N> -I<file>\n",name);
	fprintf(stderr,"-h		get this help\n");
	fprintf(stderr,"-x<N>		set debug level to <N>	[%d]\n",
		verbose);
	fprintf(stderr,"-I<file> 	use config file	<file>	[%s]\n",
		configname);
}

int main(argc,argv)
int argc;
char *argv[];
{
	int c;
	int rc;
	FILE *fp;
	faddr from,to;

	logname=LOGFILE;
	configname=CONFIGFILE;

	while ((c=getopt(argc,argv,"hx:I:")) != -1)
	switch (c)
	{
		case 'x':	verbose=atoi(optarg); break;
		case 'I':	configname=optarg; break;
		case 'h':
		default:	usage(argv[0]); exit(1);
	}

#ifdef DEBUGFILE
	freopen(DEBUGFILE,"a",stderr);
#endif

	log("start %s verbose=%d",argv[0],
		verbose);

	if (readconfig())
	{
		log("Error getting configuration, aborting");
		exit(1);
	}

	if (rc=getheader(&from,&to,stdin))
	{
		log("%s, aborting",(rc==3)?"packet not to this node":
			"bad packet");
		exit(rc);
	}
	else
	{
		log("tossing packet from %s",ascfnode(&from,0x3f));
		log("                 to %s",ascfnode(&to,0x3f));
	}

	if ((fp=tmpfile()) == NULL)
	{
		log("$Cannot open temporary file");
		exit(2);
	}
	while ((rc=getmessage(stdin,fp,&from,&to)) == 1);

	fclose(fp);

	log("end %s, %d echomail, %d netmail messages processed, rc=%d",
		argv[0],num_echo,num_mail,rc);

	return rc;
}
