#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include "lutil.h"
#include "xutil.h"
#include "ftn.h"
#include "rfcmsg.h"
#include "ftnmsg.h"
#include "areas.h"
#include "config.h"
#include "Version"

extern char *getenv(char *);
extern int getopt();
extern char *optarg;
extern int optind;

extern int atoi(char *);

extern int verbose;
extern int newsmode;
extern char *logname;
extern char *configname;
extern char passwd[];

extern FILE *openpkt(faddr *);
extern int putmessage(rfcmsg *,ftnmsg *,FILE *,FILE *);
extern void closepkt(FILE *);
extern char *bgets(char *,int,FILE *);

int usetmp=0;

void usage(name)
char *name;
{
	fprintf(stderr,"%s Version %s of %s, Copyright (c) %s\n",
		name,version,DATE,copyright);
	fprintf(stderr,"This is free software. You can do what you wish \
with it if you preserve\nthis copyright notice.\n\n");
	fprintf(stderr,"usage: %s -h -n -x<N> -I<file> -r<addr> <recip> ...\n",name);
	fprintf(stderr,"-h		get this help\n");
	fprintf(stderr,"-n		set news mode\n");
	fprintf(stderr,"-x<N>		set debug level to <N>	[%d]\n",
		verbose);
	fprintf(stderr,"-I<file> 	use config file	<file>	[%s]\n",
		configname);
	fprintf(stderr,"-r<addr>	address to route packet\n");
	fprintf(stderr,"<recip>		list of receipient addresses\n");
}

int main(argc,argv)
int argc;
char *argv[];
{
	int c;
	char *p;
	char buf[BUFSIZ];
	FILE *fp,*pkt;
	faddr *route = NULL;
	fa_list *envrecip = NULL, *envrecip_start = NULL;
	int envrecip_count=0;
	area_list *area = NULL, *area_start = NULL;
	int area_count=0;
	int msg_in=0,msg_out=0;
	rfcmsg *msg=NULL;
	ftnmsg *fmsg=NULL;
	faddr *taddr;

	logname=LOGFILE;
	configname=CONFIGFILE;

	while ((c=getopt(argc,argv,"r:x:I:nh")) != -1)
	switch (c)
	{
		case 'r':	route=parsefaddr(optarg); break;
		case 'x':	verbose=atoi(optarg); break;
		case 'I':	configname=optarg; break;
		case 'n':	newsmode=1; break;
		case 'h':
		default:	usage(argv[0]); exit(1);
	}

#ifdef DEBUGFILE
	freopen(DEBUGFILE,"a",stderr);
#endif

	if (p=strrchr(argv[0],'/')) p++;
	else p=argv[0];
	if (!strcmp(p,"ifnews")) newsmode=1;

	while (argv[optind])
	{
		if (taddr=parsefaddr(argv[optind])) 
		{
			if (envrecip)
			{
				envrecip->next = (fa_list *)
					xmalloc(sizeof(fa_list));
				envrecip=envrecip->next;
			}
			else
			{
				envrecip_start = (fa_list *)
					xmalloc(sizeof(fa_list));
				envrecip=envrecip_start;
			}
			envrecip->next=NULL;
			envrecip->addr=taddr;
			envrecip_count++;
		}
		else log("unparsable recipient \"%s\", ignored",argv[optind]);
		optind++;
	}

	if ((!newsmode) && (!envrecip_count))
	{
		log("No valid receipients specified, aborting");
		exit(1);
	}

	if (!route && newsmode && envrecip_count)
		route=envrecip_start->addr;

	if (!route) route=parsefaddr(getenv("NEWSSITE"));

	if (!route)
	{
		log("Routing address not specified, aborting");
		exit(1);
	}

	log("start %s in %s mode, route=%s verbose=%d",argv[0],
		newsmode?"news":"mail",ascinode(route,0x3f),verbose);

	for(envrecip=envrecip_start;envrecip;envrecip=envrecip->next)
	if (envrecip->addr)
		log("envrecip: %s",ascinode(envrecip->addr,0x7f));

	if (readconfig())
	{
		log("Error getting configuration, aborting");
		exit(1);
	}

	umask(066); /* packets may contain confidential information */

	if ((pkt=openpkt(route)) == NULL)
	{
		log("Unable to open packet for node %s, aborting",
			ascinode(route,0x1f));
		exit(2);
	}
	while (!feof(stdin))
	{
		usetmp=0;
		tidyrfc(msg);
		msg=parsrfc(stdin);

		if (verbose >= 9) dumpmsg(msg,stderr);

		if (newsmode)
		{
			tidy_arealist(area_start);
			area_start=areas(hdr("Newsgroups",msg));
			area_count=0;
			for(area=area_start;area;area=area->next)
			{
				area_count++;
				debug(2,"area: %s",area->name);
			}
		}

		if (((!newsmode) && (envrecip_count > 1)) ||
		    ((newsmode) && (area_count > 1)))
		{
			if ((fp=tmpfile()) == NULL)
			{
				log("$Cannot open temporary file");
				exit(2);
			}
			while(bgets(buf,sizeof(buf)-1,stdin))
				fputs(buf,fp);
			rewind(fp);
			usetmp=1;
		}
		else
		{
			fp=stdin;
			usetmp=0;
		}

		if (newsmode && (area_count < 1)) 
		{
			debug(1,"skipping news message w/o valid newsgroups");
			while(bgets(buf,sizeof(buf)-1,fp));
		}

		tidy_ftnmsg(fmsg);
		if ((fmsg=mkftnhdr(msg)) == NULL)
		{
			log("Unable to create FTN headers from RFC ones, aborting");
			exit(2);
		}

		if (!newsmode)
		for(envrecip=envrecip_start;envrecip;envrecip=envrecip->next)
		{
			fmsg->to=envrecip->addr;
			if (putmessage(msg,fmsg,fp,pkt))
			{
				log("Unable to put netmail message into the packet, aborting");
				exit(2);
			}
			if (usetmp) rewind(fp);
			fmsg->to=NULL;
			msg_out++;
		}
		else
		for(area=area_start;area;area=area->next)
		{
			fmsg->area=area->name;
			if (putmessage(msg,fmsg,fp,pkt))
			{
				log("Unable to put echo message into the packet, aborting");
				exit(2);
			}
			if (usetmp) rewind(fp);
			fmsg->area=NULL;
			msg_out++;
		}
		if (usetmp) fclose(fp);
		msg_in++;
	}

	closepkt(pkt);

	log("end %s input %d, output %d messages",argv[0],msg_in,msg_out);

	return 0;
}
