#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dbm.h>
#include "lutil.h"
#include "config.h"

static int opened=0;
static int init(void)
{
	char buf[128];
	struct stat stbuf;
	FILE *fp;

	if (database == NULL) return -1;
	if (opened == -1) return -1;
	if (opened) return 0;
	sprintf(buf,"%s.dir",database);
	if (stat(buf,&stbuf) != 0)
	{
		sprintf(buf,"%s.dir",database);
		fp=fopen(buf,"a");
		if (fp) fclose(fp);
		sprintf(buf,"%s.pag",database);
		fp=fopen(buf,"a");
		if (fp) fclose(fp);
	}
	if (dbminit(database) == 0)
	{
		opened = 1;
		return 0;
	}
	else
	{
		opened = -1;
		return -1;
	}
}

void registrate(freename,address)
char *freename,*address;
{
	datum key,val;
	char buf[128],*p,*q;
	int first;

	if (init()) return;

	strncpy(buf,freename,sizeof(buf)-1);
	first=1;
	for (p=buf,q=buf;*p;p++) switch (*p)
	{
	case '.':	*p=' '; /* fallthrough */
	case ' ':	if (first)
			{
				*(q++)=*p;
				first=0;
			}
			break;
	default:	*(q++)=*p;
			first=1;
			break;
	}
	*q='\0';
	debug(4,"registrate \"%s\" \"%s\"",buf,address);
	key.dptr=buf;
	key.dsize=strlen(buf);
	val=fetch(key);
	if (val.dptr) return;
	else
	{
		val.dptr=address;
		val.dsize=strlen(address);
		if (store(key,val) != 0)
			log("$cannot store: \"%s\" \"%s\"",buf,address);
		else log("registered \"%s\" as \"%s\"",buf,address);
	}
}

char *lookup(freename)
char *freename;
{
	datum key,val;
	static char buf[128],*p,*q;
	int sz,first;

	if (init()) return NULL;

	strncpy(buf,freename,sizeof(buf)-1);
	first=1;
	for (p=buf,q=buf;*p;p++) switch (*p)
	{
	case '.':	*p=' '; /* fallthrough */
	case ' ':	if (first)
			{
				*(q++)=*p;
				first=0;
			}
			break;
	default:	*(q++)=*p;
			first=1;
			break;
	}
	*q='\0';
	debug(4,"lookup \"%s\"",freename);
	key.dptr=buf;
	key.dsize=strlen(buf);
	val=fetch(key);
	if (val.dptr)
	{
		sz=val.dsize;
		if (sz > (sizeof(buf)-1)) sz=sizeof(buf)-1;
		strncpy(buf,val.dptr,sz);
		buf[sz]='\0';
		debug(2,"found: \"%s\"",buf);
		return(buf);
	}
	else return NULL;
}
