#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "lutil.h"
#include "xutil.h"
#include "ftn.h"

extern int atoi(char *);
extern int stricmp(char *,char *);

void tidy_faddr(addr)
faddr *addr;
{
	if (addr == NULL) return;
	if (addr->name) free(addr->name);
	if (addr->domain) free(addr->domain);
	free(addr);
}

faddr *parsefaddr(s)
char *s;
{
	faddr addr,*tmp;
	char *buf,*str,*p,*q;
	int items;

	if (s == NULL) return NULL;

	str=buf=xstrcpy(s);

	if (*(p=str+strlen(str)-1) == '\n') *(p--)='\0';
	if (((*str == '(') && (*p == ')')) ||
	    ((*str == '\"') && (*p == '\"')) ||
	    ((*str == '\'') && (*p == '\'')) ||
	    ((*str == '<') && (*p == '>')) ||
	    ((*str == '[') && (*p == ']')) ||
	    ((*str == '{') && (*p == '}')))
	{
		str++;
		*p='\0';
	}
	while (*str == ' ') str++;
	for (p=str+strlen(str)-1;*p == ' ';p--) *p='\0';

	addr.name=NULL;

	if (p=strchr(str,'!'))
	{
		*p++='\0';
		q=p + strlen(p) - 1;
		if ((*p == '\"') && (*q == '\"'))
		{
			p++;
			*q='\0';
		}
		if (strlen(p) > MAXNAME) p[MAXNAME]='\0';
		addr.name=xstrcpy(p);
		p=str;
	}
	else if (p=strrchr(str,'@')) *(p++)='\0';
	else if (p=strrchr(str,'%')) *(p++)='\0';
	else p=str;

	if ((p != str) && (!addr.name))
	{
		q=str + strlen(str) - 1;
		if ((*str == '\"') && (*q == '\"'))
		{
			str++;
			*q='\0';
		}
		else
		{
			for (q=str;*q;q++) if (*q == '.') *q = ' ';
		}
		while (*str == ' ') str++;
		if (strlen(str) > MAXNAME) str[MAXNAME]='\0';
		addr.name=xstrcpy(str);
	}

	addr.point=0;
	addr.node=0;
	addr.net=0;
	addr.zone=0;
	addr.domain=NULL;
	items=0;

	p=strtok(p,".");
	while (p)
	{
		if (strspn(p+1,"0123456789") == strlen(p+1))
		switch (*p)
		{
		case 'P':
		case 'p':	addr.point=atoi(p+1); break;
		case 'F':
		case 'f':	addr.node=atoi(p+1); items++; break;
		case 'N':
		case 'n':	addr.net=atoi(p+1); items++; break;
		case 'Z':
		case 'z':	addr.zone=atoi(p+1); break;
		default:	if (!addr.domain) 
					addr.domain=xstrcpy(p); 
				break;
		}
		else if (!addr.domain) addr.domain=xstrcpy(p);
		p=strtok(NULL,".");
	}

	free(buf);

	if (items == 2)
	{
		tmp=(faddr *)xmalloc(sizeof(addr));
		tmp->name=addr.name;
		tmp->domain=addr.domain;
		tmp->point=addr.point;
		tmp->node=addr.node;
		tmp->net=addr.net;
		tmp->zone=addr.zone;
		return tmp;
	}
	else 
	{
		if (addr.name) free(addr.name);
		if (addr.domain) free(addr.domain);
		return NULL;
	}
}

faddr *parsefnode(s)
char *s;
{
	faddr addr,*tmp;
	char *buf,*str,*p,*n;
	int good = 1;

	if (s == NULL) return NULL;

	str=buf=xstrcpy(s);

	while (*str == ' ') str++;
	if (*(p=str+strlen(str)-1) == '\n') *(p--)='\0';
	while (*p == ' ') *(p--) = '\0';

	p=str + strlen(str) - 1;
	if (((*str == '(') && (*p == ')')) ||
	    ((*str == '\"') && (*p == '\"')) ||
	    ((*str == '\'') && (*p == '\'')) ||
	    ((*str == '<') && (*p == '>')) ||
	    ((*str == '[') && (*p == ']')) ||
	    ((*str == '{') && (*p == '}')))
	{
		str++;
		*p='\0';
	}

	addr.name=NULL;
	if (p=strrchr(str,' ')) 
	{
		n=str;
		str=p+1;
		while (*p == ' ') *(p--) = '\0';
		if (!stricmp(p-2," of")) *(p-2) = '\0';
		p-=3;
		while ((*p == ' ') || (*p == ',')) *(p--) = '\0';
		if (*n != '\0') addr.name=xstrcpy(n);
	}

	if (p=strrchr(str,'@')) *(p++)='\0';
	else if (p=strrchr(str,'%')) *(p++)='\0';
	else p=NULL;

	addr.point=0;
	addr.node=0;
	addr.net=0;
	addr.zone=0;
	addr.domain=xstrcpy(p);

	if (p=strchr(str,':')) 
	{
		*(p++)='\0';
		if (strspn(str,"0123456789") != strlen(str)) good=0;
		addr.zone=atoi(str);
		str=p;
	}
	if (p=strchr(str,'/')) 
	{
		*(p++)='\0';
		if (strspn(str,"0123456789") != strlen(str)) good=0;
		addr.net=atoi(str);
		str=p;
	}
	if (p=strchr(str,'.')) 
	{
		*(p++)='\0';
		if (strspn(str,"0123456789") != strlen(str)) good=0;
		addr.node=atoi(str);
		str=p;
	}
	else
	{
		if (strspn(str,"0123456789") != strlen(str)) good=0;
		addr.node=atoi(str);
		str=NULL;
	}
	if (str)
	{
		if (strspn(str,"0123456789") != strlen(str)) good=0;
		addr.point=atoi(str);
	}

	if (buf) free(buf);

	if (good)
	{
		tmp=(faddr *)xmalloc(sizeof(addr));
		tmp->name=NULL;
		tmp->domain=addr.domain;
		tmp->point=addr.point;
		tmp->node=addr.node;
		tmp->net=addr.net;
		tmp->zone=addr.zone;
		return tmp;
	}
	else 
	{
		if (addr.domain) free(addr.domain);
		return NULL;
	}
}

char *ascinode(a,fl)
faddr *a;
int fl;
{
	static char buf[128],*p;

	buf[0]='\0';
	if ((fl & 0x80) && (a->name))
	{
		if (strchr(a->name,'.'))
			sprintf(buf+strlen(buf),"\"%s\" <",a->name);
		else
			sprintf(buf+strlen(buf),"%s <",a->name);
	}
	if ((fl & 0x40) && (a->name))
	{
		if (strchr(a->name,'.'))
		{
			sprintf(buf+strlen(buf),"\"%s\"@",a->name);
		}
		else
		{
			p=buf+strlen(buf);
			sprintf(p,"%s@",a->name);
			for (;*p;p++) if (*p == ' ') *p='.';
		}
	}
	if ((fl & 0x01) && (a->point)) 
		sprintf(buf+strlen(buf),"p%u.",a->point);
	if (fl & 0x02)
		sprintf(buf+strlen(buf),"f%u.",a->node);
	if (fl & 0x04)
		sprintf(buf+strlen(buf),"n%u.",a->net);
	if ((fl & 0x08) && (a->zone)) 
		sprintf(buf+strlen(buf),"z%u.",a->zone);
	if ((fl & 0x10) && (a->domain)) 
		sprintf(buf+strlen(buf),"%s.",a->domain);
	if ((fl & 0x20) && (a->domain))
		sprintf(buf+strlen(buf),"%s.","org");
	buf[strlen(buf)-1]='\0';
	if ((fl & 0x80) && (a->name))
		sprintf(buf+strlen(buf),">");
	return buf;
}

char *ascfnode(a,fl)
faddr *a;
int fl;
{
	static char buf[128];

	buf[0]='\0';
	if ((fl & 0x40) && (a->name)) 
		sprintf(buf+strlen(buf),"%s of ",a->name);
	if ((fl & 0x08) && (a->zone)) 
		sprintf(buf+strlen(buf),"%u:",a->zone);
	if (fl & 0x04)
		sprintf(buf+strlen(buf),"%u/",a->net);
	if (fl & 0x02) 
		sprintf(buf+strlen(buf),"%u",a->node);
	if ((fl & 0x01) && (a->point)) 
		sprintf(buf+strlen(buf),".%u",a->point);
	if ((fl & 0x10) && (a->domain)) 
		sprintf(buf+strlen(buf),"@%s",a->domain);
	return buf;
}
