.\"
.\"	ezMenu.man : Menus with a resource manager interface
.\"
.TH EZMENU 3 "21/9/90"
.ds ]W U of Rochester
.SH NAME
ezMenu - A library of menu widgets with a resource manager interface
.SH SYNOPSIS
.B #include <EzMenu/EzMenu.h>
.br
.B #include <EzMenu/EzME.h>
.sp
.SH DESCRIPTION
.PP
This package provides a resource manager interface to the simpleMenu
widgets provided in the Athena widgets. The widget class
.B ezMenuWidgetClass
is defined, subclassing the simpleMenu widget.
.sp
.SH USAGE
.PP
Include the files listed above in compilation, and link with the library
.BR libezMenu.a .
For example, you might use

.nf
	% cc [files] [Xlibs] -LEzMenu -lezMenu
.fi

.sp
.SH RESOURCE USAGE
.PP
An EzMenu widget can specify it's menu using the
.B menu
resource, as in

.nf
	*someMenu.menu:	...
.fi

or using XtSetValues(3X) with resource
.BR XtNmenu .
.PP
The menu resource should be a string consisting of parenthesized entries,
each of which is one of the following forms:
.IP "\fB(item str ...)\fP"
Creates an item with label "name". Typically an item will specify it's
action after it's name, as described below.
.IP "\fB(menu str ...)\fP"
Creates a nested menu whose name is "str"-menu. The specification of the
menu should be enclosed in parentheses.
.IP "\fB(action str)\fP"
The string "str" (which should be quoted in double-quotes) will be executed as
if it were an action specification in a translation when the item is
selected. Thus it should be a whitespace-separated list of action
procedures to call (with arguments) when the item is selected.
Double-quotes can be escaped with backslash (as can backslash itself).
.IP \fB(line)\fP
This menu item will be an unselectable line (like smeLine).
.IP \fB(blank)\fP
This menu item will be an unselectable blank space (like smeBSB with no
label).
.sp
.SH EXAMPLES
.PP
The following is a simple menu specification:

.nf
	*someMenu.menu: \e
		(item "hello" (action "do-hello()")) \e
		(item "twice" (action "do-hello() do-hello()")) \e
		(item "other" (action "do-other(foo) \e
				             do-yet-another(foo,bar)")) \e
		(line) \e
		(item "quit"  (action "quit()")),
.fi

Note the free form use of whitespace and multiple actions.
.sp
.SH FILES
.PP
EzMenu/EzMenu.h
.br
EzMenu/EzME.h	
.br
EzMenu/libezMenu.a
.sp
.SH DIAGNOSTICS
.PP
The package will complain of bad formats in the menu description with
the cryptic string "unbalanced parens or bogus format" and an indication
of context. This message can also be generated if a menu item is too long
(the current limit is 256 characters).
.sp
.SH SEE ALSO
.PP
Athena Widgets - C Language Interface
.sp
.SH AUTHOR
.PP
The EzMenu widget routines were lifted from the program
.BR xtex ,
copyright 1989 by Dirk Grunwald. That code is lifted straight from the
MIT distribution of the SimpleMenu widgets.
.br
Man page by George Ferguson (ferguson@cs.rochester.edu).
