/*
    Panel management header file
    Copyright (c) 1993, 1994 Tudor Hulubei & Andrei Pitis

This file is part of UIT (UNIX Interactive Tools)

UIT is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2, or (at your option) any later version.

UIT is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details .

You should have received a copy of the GNU General Public License along with
UIT; see the file COPYING.  If not, write to the Free Software Foundation,
675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef _PANEL_H
#define _PANEL_H


#include <dirent.h>
#include <limits.h>
#include <stddef.h>
#include <unistd.h>
#include <sys/types.h>
#include "edit.h"


/* Panel actions */
#define act_NOACTION		 0
#define act_ENTER		 1
#define act_COPY		 2
#define act_DELETE		 3
#define act_SELECT		 4
#define act_SELECT_ALL		 5
#define act_UNSELECT_ALL	 6
#define act_TOGGLE		 7

#define act_DISPLAY_NEXT_MODE	 8
#define act_DISPLAY_OWNER_GROUP	 9
#define act_DISPLAY_DATE_TIME	10
#define act_DISPLAY_SIZE	11
#define act_DISPLAY_MODE	12
#define act_DISPLAY_FULL_NAME	13

#define act_SORT_NEXT_METHOD	14
#define act_SORT_BY_NAME	15
#define act_SORT_BY_EXTENSION   16
#define act_SORT_BY_SIZE	17
#define act_SORT_BY_DATE	18
#define act_SORT_BY_MODE	19
#define act_SORT_BY_OWNER_ID	20
#define act_SORT_BY_GROUP_ID	21
#define act_SORT_BY_OWNER_NAME	22
#define act_SORT_BY_GROUP_NAME	23

#define act_MKDIR		24
#define act_MOVE		25
#define act_UP			26
#define act_DOWN		27
#define act_PGUP		28
#define act_PGDOWN		29
#define act_HOME		30
#define act_END			31
#define act_CHDIR    		32
#define act_REFRESH		33
#define act_SWITCH		34

#define act_PATTERN_SELECT	35
#define act_PATTERN_UNSELECT	36



/* File sort methods */
#define SORT_BY_NAME		 0
#define SORT_BY_EXTENSION	 1
#define SORT_BY_SIZE		 2
#define SORT_BY_DATE		 3
#define SORT_BY_MODE		 4
#define SORT_BY_OWNER_ID	 5
#define SORT_BY_GROUP_ID	 6
#define SORT_BY_OWNER_NAME	 7
#define SORT_BY_GROUP_NAME	 8


/* File display modes */
#define DISPLAY_OWNER_GROUP	 0
#define DISPLAY_DATE_TIME	 1
#define DISPLAY_SIZE		 2
#define DISPLAY_MODE		 3
#define DISPLAY_FULL_NAME	 4


/* File types */
#define DIR_ENTRY		 0
#define FILE_ENTRY		 1
#define SYMLINK_ENTRY		 2
#define FIFO_ENTRY		 3
#define SOCKET_ENTRY		 4


#define ACTIVE_PANEL_MARKER	'>'
#define INACTIVE_PANEL_MARKER	'*'


typedef struct
{
    char	 *name;
    size_t	  size;
    mode_t	  mode;
    uid_t	  uid;
    gid_t	  gid;
    time_t	  mtime;
    char	  owner[8];
    char	  group[8];
    char	  date[16];
    unsigned      selected   : 1,
    		  type       : 4,
    		  executable : 1;
} dir_entry_struct;


typedef struct
{
    DIR *dir;
    edit *edt;
    window *win;
#ifdef HAVE_LINUX
    int msdosfs;
#endif	/* HAVE_LINUX */
    int on_screen;
    int current_entry;
    char *path, *temp;
    int first_on_screen;
    unsigned int maxname;
    dir_entry_struct *dir_entry;
    int lines, columns, begin_x, begin_y;
    int last_index, found_selection, end;
    int display_mode, sort_method, chkdest;
    int entries, focus, selected_files, pathlen;
} panel;


void panel_recover(panel *this);
void panel_update(panel *this);  
void panel_update_frame(panel *this);
void panel_update_info(panel *this);
void panel_update_path(panel *this);
void panel_update_size(panel *this);
void panel_update_entry(panel *this, int entry);
void panel_trunc_fname(char *fname, char *dest, int len);
int  panel_move(panel *this, char *from, char *to);
int  panel_copy(panel *this, char *src, char *dest, int mode);
int  panel_getnext(panel *this);
int  panel_getindex(panel *this, char *str);
int  panel_getdirinfo(panel *this, char *directory, int verify);

panel *panel_init(int lines, int columns, int begin_x, int begin_y, char *path,
		  edit *edt, int *UserHeartAttack);
void  panel_end(panel *this);
void  panel_setfocus(panel *this, int status, panel *link);
void  panel_nooptimizations(panel *this);
int   panel_action(panel *this, int action, panel *link,
		   void *aux_info, int repeat_count);
char *panel_getpath(panel *this, char *temppath, unsigned len);
char *panel_getcurrentfilename(panel *this);
int   panel_getcurrentfileuid(panel *this);
int   panel_getcurrentfilegid(panel *this);
int   panel_getcurrentfilemode(panel *this);
int   panel_getcurrentfiletype(panel *this);


#endif	/* _PANEL_H */
