.TH MENU 1 "June 1990" "Newwords+ Manual"
\.@(#)menu.1 1.1 90/06/31 SMI;
.SH NAME
menu \- Runs the PSC Menu System.
.SH SYNOPSIS
menu [ menu_directory ]
.SH DESCRIPTION

Menu is a menu system that is capable of doing any unix command 
from the "menu".  The individual menus are read from menu files that
are located in a "menu" directory.  The menu files are simple text files
that may be edited with any editor.  The "menu" is flexable, the only
command line argument that is accepted is the name of a directory in which
the menu files are located.  The menu will accept the "~" in the directory
argument to specify a users home directory.  A default directory is 
specified in the menu header file.
.SH SELECTING ITEMS & USING BUILTIN COMMANDS

An item is selected from the menu simply by entering the corre-
sponding number that is displayed for the item.  It is important to know 
that you should not enter the selection and then press return.  The return
key has a special function.  The return key tells the menu to back up one
menu unless you are in the main menu, where it has no effect.  The PSC
menu system contains built in commands that allow you to: change directory,
execute a shell command, do directory listings, quit menu, help and re-draw
the screen. See the section on the "Built in Menu" for more details.

.SH BUILT IN MENU

The Built in menu is a pop-up window that displays a list of builtin commands
accessable.  This menu is accessed by entering the letter 'h' from any
menu accept the builtin menu.  Options in this menu are: c, d, h, l, m, p,
q, x, ?, L, P and <ctrl-R>.  These characters cause 
the following affects:
.nf

	'c' - Change to a new working directory.

	'd' - Get a short directory listing of the current directory.

	'h' - Use the builtin help menu.

	'l' - Get a long directory listing of the current directory.

	'm' - Return to the "main" menu.  (main.menu)

	'p' - Go to the previous menu.  This assumes that the last
 	      entry in the menu is a return to previous menu.  If it
 	      is not, it will execute the last entry a command.

	'q' - Quit the Menu.

	'x' - Execute a shell command.

	'?' - Get help on a specified menu entry.  The help file for 
	      that entry must exist for help to be given.

	'L' - Log off the system.  This assumes that you ran the menu
 	      from your login shell.  If you did not do this it will 
              kill the shell it was run from.

	'P' - Print a file using the visual directory to select the
 	      file to be printed.

	<ctrl-R> Re-draw the screen in cases where you get garbled. 
                 (control key and 'R' are pressed at the same time).
.fi

.SH MENU FILES
The Menu files have a specific format that must be followed.  The first
character in each line must be $, ?, #, %, +, *, @, &, 1, 2, 3, 4, 5, 6.
These are "key" characters that tell "menu" what kind of operation is to
be performed.
.PP
\'$'     This character means that this line is the menu header for this
menu, this must be the first character in the line.
This must always be the first line in the "menu" file.  The second
character in this line is skipped anything after the second column is
interpreted as the menu heading.
.PP
\'?'	This character means that this line is a comment to be displayed to
the user when they use the menu.  
.PP
\'#'	This character means that this line is a the name or path to 
the help file on a menu selection.
.PP
\'%'	 Execute in a sub-shell but do not use the continue line
upon completion of command.  Similar to the '*' option.
.PP
\'+'     This character means that output from the name program be 
output to the "menu" window.  It is best if the output is 70 columns
wide or less, anything after 70 columns is chopped off. Some good examples
are ls and ls -l.  Any program which actually does screen manipulation cannot
use the '+' option (It Will really get messed up).
.PP
\'@'	 This character specifies that the menu to be loaded is to
be considered the main menu so that pressing return will not do anything.
.PP
\'&'	 This character specifies a menu to be loaded.  The path to the menu
file is the default or the specified one given in the command argument.
.PP
\'*'	 This character means that the invoked program will interfere with
the "menu" window.  Such programs include more, less and any games.
.PP
\'1'	 This character specifies that one file name is expected as an argument
for the program to be run.  A good example would be: vi <filename>.
.PP
\'2'	 This character specifies that two file names are expected as
arguments for the program to be run.  A good exmample would be:       
cp <file1> <file2>.
.PP
\'3'	 This character specifies that a user name is expected as an argument
for the program to be run.  A good exapmple would be:	mail <user>.
.PP
\'4'	 This character specifies a topic to be used as an argument to the 
program to be run.  A good example would be:	man <topic>.
.PP
\'5'     Execute a C-Shell command with a file name as an argument.
Uses visual directory listing and a file is selected by using the arrow
keys.  Useful when you know the file must exist.
.PP
\'6'	Execute a command in a pipe with a file name as an argument.
Uses visual directory listing and a file is selected by using the arrow 
keys.  Useful when you know the file must exist.
\'d'	Change to directory before executing command. 

.SH DEFAULTS
	The menu program looks for a file called "main.menu" in the default
or specified directory.  If the Directory does not exist or is not accessable
the program will tell you of the condition and quietly exit.  If the file
"main.menu" does not exist in the named directory the program will notify you
that it could not find any menu files and quietly exits.  The return key
if pressed will do the last thing in the menu, unless that menu is defined
to be the main menu (this is done to make it easy to back out of menus
assuming of course that return to previous menu is that last option in that
menu).
.SH EXAMPLE MENU FILE
.nf
$ File Management Menu
5 /bin/rm -i
# /usr/local/lib/menu_help/remove.hlp
? Remove a file.
2 /bin/cp -i
? Copy a file.
5 rm -i
? Remove a single file.
* rm -i *
? Cleanup your files.
+ /bin/ls -l
? List your Files.
& menu.1
? Return to main Menu.
.fi

.SH CAUTIONS
If you use the '+' menu command that tells the menu program to send
output to the menu window with a command that uses cursor addressing
or requires user input you may get some rather interesting results.
