.de Id
.ds Rv \\$3
.ds Dt \\$4
..
.Id $Id: formail.man,v 2.12 1992/01/31 12:07:40 berg Rel $
.de Sh
.br
.ne 11
.SH "\\$1"
..
.de Ss
.br
.ne 10
.SS "\\$1"
..
.de Tp
.br
.ne 9
.TP "\\$1"
..
.de Rs
.na
.nf
.RS
..
.de Re
.RE
.fi
.ad
..
.TH FORMAIL 1 \*(Dt BuGless
.SH NAME
.na
formail \- mail (re)formatter
.SH SYNOPSIS
.B formail
[
.I "\fB\+FM_SKIP+\fPskip"
] [
.I "\fB\+FM_TOTAL+\fPtotal"
] [
.B \-+FM_BOGUS++FM_FORCE++FM_REPLY++FM_KEEPB++FM_TRUST++FM_NOWAIT++FM_EVERY++FM_DIGEST++FM_QUIET+
]
.if n .ti +0.5i
[
.B \-+FM_EXTRACT+
.I header field
] [
.B \-+FM_ADD_IFNOT+
.I header field
]
.if n .ti +0.5i
[
.B \-+FM_REN_INSERT+
.I header field
] [
.B \-+FM_DEL_INSERT+
.I header field
]
.if n .ti +0.5i
[
.B \-+FM_SPLIT+
.I command
.I arg
\&.\|.\|.
]
.ad
.Sh DESCRIPTION
.B formail
is a filter that can be used to force mail into mailbox format, perform real
rigorous `+FROM+' escaping, generate auto-replying headers, do simple
header munging/extracting or split up a
mailbox/digest/articles file.  The mail/mailbox/article contents will be
expected on stdin.
.LP
If formail is supposed to determine the sender of the mail, but is unable
to find any, it will substitute `+UNKNOWN+'.
.LP
If formail is started without any command line options, it will force any
mail coming from stdin into mailbox format and will escape
.B all
bogus `+FROM+' lines with a `+ESCAP+'.
.Sh OPTIONS
.Tp 0.5i
.B \-+FM_BOGUS+
Don't escape any bogus mailbox headers (i.e. lines starting with `+FROM+').
.Tp
.B \-+FM_FORCE+
Force formail to simply pass along any non-mailbox format (i.e. don't
generate a `+FROM+' line as the first line).
.Tp
.B \-+FM_REPLY+
Generate an auto-reply header.
.Tp
.B \-+FM_KEEPB+
When generating the auto-reply header, keep the body as well.  If used
together with the
.B \-+FM_BOGUS+
option then the body will not be escaped.
.Tp
.B \-+FM_TRUST+
Trust the sender to have used a valid return address in his header.  This
option will be most useful when generating auto-reply headers from news
articles.  If this option is not turned on, formail tries to digest the most
probable valid return address itself.
.Tp
.B \-+FM_SPLIT+
The input will be split up into seperate mail messages, and piped into
a program one by one (a new program is started for every part).
.B \-+FM_SPLIT+
has to be the last option specified, the first argument following it
is expected to be the name of a program, any other arguments will be passed
along to it.
.Tp
.B \-+FM_NOWAIT+
Tell formail not to wait for every program to finish before starting the next.
.Tp
.B \-+FM_EVERY+
Consider every line starting with `+FROM+' to be the start of a new mail
message (this is normally not the case).
.Tp
.B \-+FM_DIGEST+
Enables formail to split up digests/articles into their original parts.
.Tp
.B \-+FM_QUIET+
Tells formail to ignore any write errors on stdout.
.Tp
.I "\fB\-+FM_EXTRACT+\fP header field"
Extract this
.I header field
from the header, display it as a single line.
.Tp
.I "\fB\-+FM_ADD_IFNOT+\fP header field"
Append a custom
.I header field
onto the header; but only if a similar field does not exist yet.
.Tp
.I "\fB\-+FM_REN_INSERT+\fP header field"
Same as
.BR \-+FM_ADD_IFNOT+ ,
except that any existing similar fields are renamed by prepending
an ``+OLD_PREFIX+'' prefix.  If
.I header field
consists only of a field-name, it will not be appended.
.Tp
.I "\fB\-+FM_DEL_INSERT+\fP header field"
Same as
.BR \-+FM_REN_INSERT+ ,
except that any existing similar fields are simply removed.
.Tp
.I "\fB\+FM_SKIP+\fPskip"
Skip the first
.I skip
messages while splitting.
.Tp
.I "\fB\+FM_TOTAL+\fPtotal"
Output at most
.I total
messages while splitting.
.Sh EXAMPLES
To use it as a general formatter in front of procmail include the following
procmail recipe at the top of your +PROCMAILRC+ file:
.ne 2
.Rs
:0 wf
| formail
.Re
.LP
To split up a digest one usually uses:
.Rs
formail +FM_SKIP+1 -+FM_DIGEST++FM_SPLIT+ cat >>the_mailbox_of_your_choice
.Re
or
.Rs
formail +FM_SKIP+1 -+FM_DIGEST++FM_SPLIT+ procmail
.Re
.LP
To supersede the Reply-To: field in a header you could use:
.Rs
formail -+FM_REN_INSERT+ "Reply-To: foo@bar"
.Re
.Sh MISCELLANEOUS
The regular expression that is used to find `real' postmarks is:
.Rs
"\\n\\n+FROM++[^\\t\\n ]+ +[^\\n\\t ]"
.Re
.Sh "SEE ALSO"
.na
.BR mail (1),
.BR binmail (1),
.BR sendmail (8),
.BR procmail (1),
.BR sh (1)
.ad
.Sh DIAGNOSTICS
.Tp 2.3i
Can't fork
Too many processes on this machine.
.Tp
Couldn't write to stdout
The program that formail was trying to pipe into didn't accept all the data
formail sent to it; this diagnostic can be disabled by the
.B \-+FM_QUIET+
option.
.Tp
Failed to execute "x"
Program not in path, or not executable.
.Tp
File table full
Too many open files on this machine.
.Tp
Invalid field-name: "x"
The specified field-name "x" does not contain a colon.
.Sh WARNINGS
You can save yourself and others a lot of mischief if you try to avoid using
this autoreply feature on mails coming through mailinglists.  Depending
on the format of the incoming mail (which in turn depends on both the
original sender's mail agent and the mailinglist setup) formail could
decide to generate an autoreply header that replies to the list (if
the original sender was careful enough though, formail will be able to pick
his/her address, instead of the list's).  Now if the list is not intelligent
enough (most aren't) this autoreply will be widely distributed.
.Sh BUGS
formail does not do full RFC 822 parsing while generating a `+FROM+' or
a `To: ' line, hence it can be fooled by some real tricky escaped/quoted
strings with `<', `>' or `(' characters in them.
.Sh AUTHOR
Stephen R. van den Berg at RWTH-Aachen, Germany
.Rs
berg@messua.informatik.rwth-aachen.de
berg@physik.tu-muenchen.de
.Re
