.\" @(#)listserv.l 1.03 92/03/03 SMI; UCSD Edition
.TH LISTSERV L "03 March 1992"
.SH NAME
listserv \- manage mailing lists via sendmail interface
.SH SYNOPSIS
.B /usr/mail/listserv
.SH DESCRIPTION
.LP
.B listserv
is a mail server which allows users to easily list the available mailing
lists on a machine, and add or delete themselves from lists, through
electronic mail.  A user communicates with
.B listserv
by mailing it a file containing
.B listserv
commands, one to each line.  The general syntax for mail to a listserver is
.IB mail
.IB listserv@host.domain
.LP
The
.B listserv
commands available on the UCSD
.B listserv
program are as follows.  Several commands may be included in a single mail
message, but must be on separate lines in the message.
.TP 15
.B help
Returns the contents of the HELPFILE, including instructions on the use of
all
.B listserv
commands.
.TP
\fBhelp \fIcommand\fR
Returns the help file for the indicated
.B listserv
command.
.TP
\fBhelp \fIlistname\fR
Returns the .info file for the indicated
.I listname.
.TP
.B index
Gives a list of which mailing lists are available on the machine on which
the listserver resides.
.TP
.B longindex
Returns a list of all mailing lists available, including information
contained in the .info and .pub files for those lists.
.TP
\fBadd \fIlistname\fR
Adds the user sending the message to the indicated listname with the
address found in the From: line in the mail message.
.TP
\fBadd \fIaddress listname\fR
Adds the user indicated in
.I address
to the indicated listname.
.TP
\fBdelete \fIlistname\fR
Attempts to unsubscribe the user sending the message from the
indicated listname, using the
address found in the From: line in the mail message.
.TP
\fBdelete \fIaddress listname\fR
Attempts to unsubscribe the user indicated in
.I address
from the indicated listname.
.TP
.B list
Provides a list of the mailing lists to which the user whose address is
found in the From: line of the mail message is subscribed.
.TP
\fBlist \fIaddress\fR
Provides a list of the mailing lists to which the user whose address is
.I address
is subscribed.
.TP
\fBfaq \fIlistname\fR
If available, returns a list of Frequently Asked Questions about the
indicated
.I listname
and their answers.
.TP
.B info
Returns a list of all information sheets and listserv sendable files 
available.
.TP
\fBinfo \fIfilename\fR
Returns the indicated file or info sheet.
.SH FILES
.IP /usr/mail/maillists/*.info 30
Short descriptions of locally-subscribable mailing lists.  These files
must exist for a mailing list to be accessable through
.B listserv.
.IP /usr/mail/maillists/*.pub 30
Short descriptions of publicly-subscribable mailing lists.  These files
must exist for a mailing list to be accessable through
.B listserv
from machines outside the local domain.
.IP /usr/mail/maillists/*.intro 30
Optional; provides an introductory posting which, if it exists, is
automatically sent to new users when they subscribe.
.IP /usr/mail/maillists/*.faq 30
An optional FAQ (Frequently Asked Questions) posting which, if it exists,
is sent to users when they submit the
.B faq
.BI listname
command to
.B listserv
for a particular mailing list.
.SH "SEE ALSO"
.BR mail (1),
.BR sendmail (8).
.SH BUGS
.LP
Not a bug, but if the user's home machine's sendmail.cf file has changed
since she subscribed to a list, she may be unable to unsubscribe using the
.B delete
.BI listname
syntax.  If she does not know how her From: line appeared previously, it
may be necessary for her to contact a human to unsubscribe from the
mailing list.
.SH NOTES
.LP
Please contact
.B listserv-manager@ucsd.edu
for questions or updates to this program.
