#
#            T H E    P I N E    M A I L   S Y S T E M
#
#   Laurence Lundblade and Mike Seibel
#   Networks and Distributed Computing
#   Computing and Communications
#   University of Washington
#   Administration Building, AG-44
#   Seattle, Washington, 98195, USA
#   Internet: lgl@CAC.Washington.EDU
#             mikes@CAC.Washington.EDU
#
#   Please address all bugs and comments to "pine-bugs@cac.washington.edu"
#
#   HP/UX port: David L. Miller
#               Computing and Telecommunications
#               Washington State University Tri-Cities
#               Richland, WA 99352, USA
#               dmiller@beta.tricity.wsu.edu
#
#   Date: 22 May 1992
#   Last Edited: 22 May 1992
#      
#   Copyright 1989, 1990, 1991  University of Washington
#
#    Permission to use, copy, modify, and distribute this software and its
#   documentation for any purpose and without fee to the University of
#   Washington is hereby granted, provided that the above copyright notice
#   appears in all copies and that both the above copyright notice and this
#   permission notice appear in supporting documentation, and that the name of
#   the University of Washington not be used in advertising or publicity
#   pertaining to distribution of the software without specific, written prior
#   permission.  This software is made available "as is", and
#   THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
#   WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
#   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
#   NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
#   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
#   LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
#   (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
#   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#  
#
#   Pine is in part based on The Elm Mail System:
#    ***********************************************************************
#    *  The Elm Mail System  -  $Revision: 2.13 $   $State: Exp $          *
#    *                                                                     *
#    * 			Copyright (c) 1986, 1987 Dave Taylor              *
#    * 			Copyright (c) 1988, 1989 USENET Community Trust   *
#    ***********************************************************************
# 
#


#
#     makefile for the Pine mail system for HP/UX 8.0
#


#
#   Most commonly fiddled flags for compiler.
#   Uncomment the setttings desired here
#
OPTIMIZE=    # -O
PROFILE=     # -pg
DEBUG=       -g -DDEBUG


LIBES =  -ltermcap -lnet 


CFLAGS= $(OPTIMIZE) $(PROFILE) $(DEBUG)

obj=    helptext.o addrbook.o addrutil.o adrbklib.o args.o \
	pine.o  \
	folder.o help.o imap.o init.o \
	mailcmd.o mailindx.o mailview.o \
	newmail.o other.o print.o \
	reply.o screen.o send.o signals.o  status.o \
	strings.o ttyout.o ttyin.o os.o 


cfiles= helptext.c addrbook.c addrutil.c adrbklib.c args.c \
	pine.c \
	folder.c help.c imap.c init.c \
	mailcmd.c mailindx.c mailview.c \
	newmail.c other.c print.c\
	reply.c screen.c \
	send.c signals.c  status.c  strings.c  \
	ttyout.c ttyin.c os.c 


# The & means make in parallel
        
pine: $& ${obj} 
	cc ${LDFLAGS} $(CFLAGS) -o pine ${obj} ../pico/libpico.a \
            ../c-client/c-client.a $(LIBES)

plib.a: $& ${obj}
	ar qc $@ ${obj}

saber_src:	$(cfiles)
	#load $(CFLAGS) $(cfiles)
saber_obj:	$(obj)
	#load $(CFLAGS) $(obj)


HEADERS= headers.h pine.h os.h

addrbook.o:	addrbook.c  $(HEADERS)
addrutil.o:	addrutil.c  $(HEADERS) adrbklib.h
adrbklib.o: 	adrbklib.c  $(HEADERS) adrbklib.h
args.o:		args.c      $(HEADERS)
pine.o:		pine.c      $(HEADERS)
folder.o:	folder.c    $(HEADERS)
help.o:		help.c      $(HEADERS)
helptext.o:	helptext.c
imap.o:	        imap.c      $(HEADERS)
init.o:		init.c      $(HEADERS)
mailcmd.o:	mailcmd.c   $(HEADERS)
mailindx.o:	mailindx.c  $(HEADERS)
mailview.o:	mailview.c  $(HEADERS)
newmail.o:	newmail.c   $(HEADERS)
other.o:	other.c     $(HEADERS)
print.o:	print.c     $(HEADERS)
reply.o:	reply.c     $(HEADERS)
screen.o:	screen.c    $(HEADERS)
send.o:	        send.c      $(HEADERS)
signals.o:	signals.c   $(HEADERS)
status.o:	status.c    $(HEADERS)
strings.o:	strings.c   $(HEADERS)
ttyout.o:	ttyout.c    $(HEADERS)
ttyin.o:	ttyin.c     $(HEADERS)
os.o:	        os.c        $(HEADERS)

helptext.c:	pine.hlp 
		./cmplhelp.sh  < pine.hlp > helptext.c
		./cmplhlp2.sh  < pine.hlp > helptext.h

helptext.h:	pine.hlp
		./cmplhlp2.sh  <  pine.hlp > helptext.h

os.h:	os-hpp.h
	ln -s os-hpp.h os.h        

os.c:	os-hpp.c
	ln -s os-hpp.c os.c
        

