/*
 * Program:	Operating system dependent routines - System V R 3
 *          
 *  WARNING -- this is an incomplete half modified version for System V R 3
 *               
 *
 * Author:	Michael Seibel
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: mikes@cac.washington.edu
 *
 * Date:	6 Jan 1992
 * Last Edited:	6 Jan 1992
 *
 * Copyright 1991 by the University of Washington
 *
 *  Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both the
 * above copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the University of Washington not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  This software is made
 * available "as is", and
 * THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
 * NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
 * (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifndef	OSDEP_H
#define	OSDEP_H

#define POSIX

#ifdef	dyn
#include	<strings.h>
#else
#include	<string.h>
#endif
#undef	CTRL
#include	<signal.h>
#if defined (ptx) || defined (aix)
/* DYNIX/ptx signal semantics are AT&T/POSIX; the sigset() call sets
   the handler permanently, more like BSD signal(). */
#define signal(s,f) sigset (s, f)
#endif

#include	<ctype.h>
#include	<sys/types.h>

#ifdef	POSIX
#include	<dirent.h>
#else
#include	<sys/dir.h>
#endif
#include	<sys/ioctl.h>		/* to get at the typeahead */
#include	<sys/stat.h>

/* Machine/OS definition			*/
#if	defined(ptx)
#define TERMINFO	1               /* Use TERMINFO                  */
#else
#define TERMCAP		1               /* Use TERMCAP                  */
#endif

/*
 * File name separator, as a char and string
 */
#define	C_FILESEP	'/'
#define	S_FILESEP	"/"


/*
 * Place to put dead/cancelled compositions
 */
#define MAILGRAVE       "~/mail/.dead.letter"


/*
 * What and where the tool that checks spelling is located.  If this is
 * undefined, then the spelling checker is not compiled into pico.
 */
#define	SPELLER		"/usr/bin/spell"

/* memcpy() is no good for overlapping blocks.  If that's a problem, use
   the memmove() in ../c-client */
#if defined (ptx) || defined(sv3)
#define bcopy(a,b,s) memcpy (b, a, s)
#endif
/* memmove() is a built-in for AIX 3.2 xlc. */
#if defined (aix)
#define bcopy(a,b,s) memmove (b, a, s)
#endif


#if	defined(dyn)
#define	strchr	index			/* Dynix doesn't know about strchr */
#define	strrchr	rindex
#endif	/* dyn */

extern struct KBSTREE *kpadseqs;
extern int kbseq();

#ifdef	termdef
#if	ANSI
#define NROW    25                      /* Screen size.                 */
#define NCOL    80                      /* Edit if you want to.         */
#endif
#else
#if	TERMCAP
extern struct KBSTREE *kpadseqs;
#endif	/* TERMCAP */
#endif

#ifdef	maindef

jmp_buf	got_hup;		/* stack environment to handle SIGHUP */

#endif

#endif	/* OSDEP_H */
