/* The Quoter Version .92B (c) 1996 by Stephen Jacobs <sjacob1@gl.umbc.edu>
 * This file is released under the GPL.
 * Please see COPYING for details.
 */

/* This is a Simple ADT for quotes, holds em and spits em out.
 * Also Tries no to eat too much memory :>
 */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "quotes.h"

/* Function: create_quotes
 * Purpose: Allocates Memory for the quote structure.
 */
quote_type
create_quotes (void)
{
   quote_type quotes;
   quotes = malloc(sizeof(quote_struct));
   quotes->quotes = NULL;
   quotes->number = 0;
   return (quotes);
}

/* Function: num_quotes
 * Purpose: returns the number of quotes
 */
int 
num_quotes (quote_type quotes)
{
   return(quotes->number);
}

/* Function: get_quote
 * Purpose: Returns the quote (string) Specified.
 */
char *
get_quote (quote_type quotes, int num)
{
   assert (num <= num_quotes(quotes));
   return ((quotes->quotes)[(num-1)]);
}

/* Function: add_quote
 * Purpose: adds a quote (string) to the quote_type.
 */
void
add_quote (char *quote, quote_type quotes)
{
   int x;
   char **temp_array;
   temp_array = calloc (num_quotes(quotes), sizeof (char*));
   /* Re-Allocate enough memory to store The Quote, and check for emptys... */
   if (quotes->quotes == NULL) {
     quotes->quotes = malloc (sizeof(char*));
   }
   
   else quotes->quotes = realloc (quotes->quotes, sizeof(char*) * 
				  (num_quotes (quotes) + 1));
   if (quotes->quotes == NULL) {
      fprintf (stderr,"Error - Memory Allocation Error, Out of Memory?\n");
      exit(EXIT_FAILURE);
   }
   /* Now copy the new quote into the array and make space */
   (quotes->quotes)[num_quotes(quotes)] = calloc (strlen (quote), sizeof(char));
   for (x=0; x<strlen(quote); x++) {
     (quotes->quotes)[num_quotes(quotes)][x] = quote[x]; 
   }
   /* Now increment the counter for the number of quotes */
   (quotes->number)++;
   /* Be nice to the memory :> */
   free (temp_array);
}

   

