/* The Quoter Version .92B (c) 1996 by Stephen Jacobs <sjacob1@gl.umbc.edu>
 * This file is released under the GPL.
 * The Quoter comes with ABSOLUTELY NO WARRANTY. This is free software.
 * Please see COPYING for details.
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>
#include "main.h"

/* Now some basic definitions... Change these as needed */
#define VERSION "0.93 - BETA"
#define MAX_QUOTE_LENGTH 2000
#define MAX_SIG_INFO MAX_QUOTE_LENGTH
/* Do we need some global variables??? */

int 
main (int argc, char *argv[]) 
{
   int check, quote_num;
   FILE *filename;
   quote_type quotes, fixed_quote;
   char *quote;
   quotes = create_quotes ();
   fixed_quote = create_quotes();
   printf ("The Quoter Version %s - Copyright 1996 Stephen Jacobs\n"
	   "                        - <sjacob1@gl.umbc.edu>\n", VERSION);
   /* Get all command line options here... */            /* Globals??? */
   printf ("Reading Quotes File...\n");
   if (argc < 3) {
      if ((filename = fopen("quotelist", "r")) == NULL)
	if ((filename = fopen(".quotelist", "r")) == NULL)
	if ((filename = fopen(".quoteslist", "r")) == NULL) {
	   fprintf (stderr, "Error - Could not open Quotes File.\n");
	   exit (EXIT_FAILURE);
	}
   }
   /* Command line option for reading file... (Use global variables???) */
   read_quotes (quotes, filename);
   fclose (filename);
   srand(time(NULL));
   quote_num = ((rand() % (num_quotes (quotes) + 1)));
   if (quote_num == 0) quote_num++;
   quote = get_quote  (quotes, quote_num);
   printf("Total Quotes Found: %d\n\n", num_quotes(quotes));
   printf ("Your new Quote is:\n%s\n", quote);
   /* This will be gone soon... need more .sig support... */
   if ((filename = fopen (".signature", "w")) == NULL) {
      fprintf (stderr, "Error - Unknown Error Writing File.");
      exit (EXIT_FAILURE);
   }
   fprintf (filename, "%s", quote);
   fclose (filename);

/* Now Write the file */
   write_sig (".signature", quote);
}


/* Function: read_quotes
 * Purpose: Reads all the quotes in from a file. Keeping the "'s in them.
 */
void 
read_quotes (quote_type quotes, FILE *filename)
{
   int read, counter=0;
   char string[MAX_QUOTE_LENGTH];
   while ((read = fgetc (filename)) != EOF) {
      if (read == '"') {
	 string[0] = '"';
	 counter = 1;
	 while ((read = fgetc (filename)) != EOF) { 
	    if (read == '"') {
	       string[counter] = '"';
	       string[counter+1] = '\0';
	       add_quote (string, quotes);
	       break;
	    }
	    /* Control Character is \ for any character (ie ") */
	    if (read == '\\')
	      if ((read = fgetc (filename)) == EOF) {
		 fprintf (stderr, "Error - Unexpected End of File\n");
		 exit(EXIT_FAILURE);
	      }
	    string[counter] = read;
	    counter++;
	    if (counter == MAX_QUOTE_LENGTH) {
	       fprintf (stderr, "Error - Quotes must be shorter than"
			" %s length.\n", MAX_QUOTE_LENGTH);
	       exit (EXIT_FAILURE);
	    }
	 }
	 if (read == EOF) {
	    fprintf(stderr, "Error - Unexpected End of File\n");
	    exit(EXIT_FAILURE);
	 }
      }
   }
}

/* Function: write_sig
 * Purpose: Writes the quote to a signature File... and keeps some data.
 *          See the readme for details...
 */
void
write_sig (char *signame, char *quote)
{
}




