/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of California at Berkeley. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 *	@(#)v7.local.h	5.4 (Berkeley) 2/18/88
 */

/*
 * Declarations and constants specific to an installation.
 *
 * Vax/Unix version 7.
 */

#define	GETHOST				/* System has gethostname syscall */
#ifdef	GETHOST
# define	LOCAL		EMPTYID		/* Dynamically determined local host */
# ifdef	M_XENIX
#  define	UNAME			/* define this if uname() returns the correct nodename */
# endif
#else
# define	LOCAL		'j'		/* Local host id */
#endif	GETHOST

#define MAIL	"/usr/bin/smail"	/* Name of mail sender */
/* #define SENDMAIL	"/usr/lib/sendmail"
					/* Name of classy mail deliverer */
#define	EDITOR		"/usr/bin/ed"	/* Name of text editor */
#define	VISUAL		"/usr/bin/vi"	/* Name of display editor */
#define	SHELL		"/bin/sh"	/* Standard shell */
#define	MORE		"/usr/bin/more"	/* Standard output pager */
#define	HELPFILE	"/usr/lib/Mail.help"
					/* Name of casual help file */
#define	THELPFILE	"/usr/lib/Mail.help.~"
					/* Name of casual tilde help */
#define	POSTAGE		"/usr/adm/maillog"
					/* Where to audit mail sending */
#define	MASTER		"/usr/lib/Mail.rc"
#define	APPEND				/* New mail goes to end of mailbox */
#define CANLOCK				/* Locking protocol actually works */
#define	UTIME				/* System implements utime(2) */


/*----------------------------------------------------------------------
 * Various kinds of mailbox locking.
 * You may define one or both of ML_DOTLOCK and ML_DOTMLK.
 * You may define no more than one of ML_FCNTL, ML_LOCKF and ML_LOCKING.
 *
 * File creation locking:
 *     ML_DOTLOCK   create <mailbox>.lock       (most systems except BSD4.3)
 *     ML_DOTMLK    create /tmp/<basename>.mlk  (Xenix)
 *
 * Kernel record locking:
 *     ML_FCNTL     lock with fcntl(F_SETLKW)   (SVID systems only)
 *     ML_LOCKF     lock with lockf(F_LOCK)     (SVID systems only)
 *     ML_LOCKING   lock with locking(LK_LOCK)  (Xenix systems only)
 */

#ifdef M_XENIX
#define ML_DOTMLK
#define ML_LOCKING
#else
#define ML_DOTLOCK
#define	ML_FLOCK
#endif


